/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner;

import ai.timefold.solver.core.api.domain.solution.cloner.DeepPlanningClone;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningFieldCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.cloner.ShallowCloningFieldCloner;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.ConcurrentMemoization;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public final class FieldAccessingSolutionCloner<Solution_>
implements SolutionCloner<Solution_> {
    private static final int MINIMUM_EXPECTED_OBJECT_COUNT = 1000;
    private final Map<Class<?>, ClassMetadata> classMetadataMemoization = new ConcurrentMemoization();
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Function<Class<?>, ClassMetadata> classMetadataConstructor;
    private final AtomicInteger expectedObjectCountRef = new AtomicInteger(1000);

    public FieldAccessingSolutionCloner(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.classMetadataConstructor = clz -> new ClassMetadata(solutionDescriptor, (Class<?>)clz);
    }

    @Override
    public @NonNull Solution_ cloneSolution(@NonNull Solution_ originalSolution) {
        int expectedObjectCount = this.expectedObjectCountRef.get();
        Map<Object, Object> originalToCloneMap = CollectionUtils.newIdentityHashMap(expectedObjectCount);
        ArrayDeque<Unprocessed> unprocessedQueue = new ArrayDeque<Unprocessed>(expectedObjectCount);
        Solution_ cloneSolution = this.clone(originalSolution, originalToCloneMap, unprocessedQueue, this.retrieveClassMetadata(originalSolution.getClass()));
        while (!unprocessedQueue.isEmpty()) {
            Unprocessed unprocessed = unprocessedQueue.remove();
            Object cloneValue = this.process(unprocessed, originalToCloneMap, unprocessedQueue);
            FieldCloningUtils.setObjectFieldValue(unprocessed.bean, unprocessed.cloner.getFieldHandles(), cloneValue);
        }
        this.expectedObjectCountRef.updateAndGet(old -> FieldAccessingSolutionCloner.decideNextExpectedObjectCount(old, originalToCloneMap.size()));
        this.validateCloneSolution(originalSolution, cloneSolution);
        return cloneSolution;
    }

    private static int decideNextExpectedObjectCount(int currentExpectedObjectCount, int currentObjectCount) {
        int halfTheDifference = (int)Math.round((double)Math.abs(currentObjectCount - currentExpectedObjectCount) / 2.0);
        if (currentObjectCount > currentExpectedObjectCount) {
            return Math.min(currentExpectedObjectCount + halfTheDifference, Integer.MAX_VALUE);
        }
        if (currentObjectCount < currentExpectedObjectCount) {
            return Math.max(currentExpectedObjectCount - halfTheDifference, 1000);
        }
        return currentExpectedObjectCount;
    }

    public Object gizmoFallbackDeepClone(Object originalValue, Map<Object, Object> originalToCloneMap) {
        if (originalValue == null) {
            return null;
        }
        ArrayDeque<Unprocessed> unprocessedQueue = new ArrayDeque<Unprocessed>(this.expectedObjectCountRef.get());
        Class<?> fieldType = originalValue.getClass();
        return this.clone(originalValue, originalToCloneMap, unprocessedQueue, fieldType);
    }

    private Object clone(Object originalValue, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue, Class<?> fieldType) {
        if (originalValue instanceof Collection) {
            Collection collection = (Collection)originalValue;
            return this.cloneCollection(fieldType, collection, originalToCloneMap, unprocessedQueue);
        }
        if (originalValue instanceof Map) {
            Map map = (Map)originalValue;
            return this.cloneMap(fieldType, map, originalToCloneMap, unprocessedQueue);
        }
        Class<?> originalClass = originalValue.getClass();
        if (originalClass.isArray()) {
            return this.cloneArray(fieldType, originalValue, originalToCloneMap, unprocessedQueue);
        }
        return this.clone(originalValue, originalToCloneMap, unprocessedQueue, this.retrieveClassMetadata(originalClass));
    }

    private Object process(Unprocessed unprocessed, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        Object originalValue = unprocessed.originalValue;
        Field field = unprocessed.cloner.getFieldHandles().field();
        Class<?> fieldType = field.getType();
        return this.clone(originalValue, originalToCloneMap, unprocessedQueue, fieldType);
    }

    private <C> C clone(C original, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue, ClassMetadata declaringClassMetadata) {
        if (original == null) {
            return null;
        }
        Object existingClone = originalToCloneMap.get(original);
        if (existingClone != null) {
            return (C)existingClone;
        }
        Class<?> declaringClass = original.getClass();
        C clone = FieldAccessingSolutionCloner.constructClone(original, declaringClassMetadata);
        originalToCloneMap.put(original, clone);
        this.copyFields(declaringClass, original, clone, unprocessedQueue, declaringClassMetadata);
        return clone;
    }

    private static <C> C constructClone(C original, ClassMetadata classMetadata) {
        if (original instanceof PlanningCloneable) {
            PlanningCloneable planningCloneable = (PlanningCloneable)original;
            return (C)planningCloneable.createNewInstance();
        }
        return FieldAccessingSolutionCloner.constructClone(classMetadata);
    }

    private static <C> C constructClone(ClassMetadata classMetadata) {
        MethodHandle constructor = classMetadata.getConstructor();
        try {
            return (C)constructor.invoke();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Can not create a new instance of class (%s) for a planning clone, using its no-arg constructor.".formatted(classMetadata.declaringClass.getCanonicalName()), e);
        }
    }

    private <C> void copyFields(Class<C> clazz, C original, C clone, Queue<Unprocessed> unprocessedQueue, ClassMetadata declaringClassMetadata) {
        for (ShallowCloningFieldCloner shallowCloningFieldCloner : declaringClassMetadata.getCopiedFieldArray()) {
            shallowCloningFieldCloner.clone(original, clone);
        }
        for (DeepCloningFieldCloner deepCloningFieldCloner : declaringClassMetadata.getClonedFieldArray()) {
            Object unprocessedValue = deepCloningFieldCloner.clone(this.solutionDescriptor, original, clone);
            if (unprocessedValue == null) continue;
            unprocessedQueue.add(new Unprocessed(clone, deepCloningFieldCloner, unprocessedValue));
        }
        Class<C> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            this.copyFields(superclass, original, clone, unprocessedQueue, this.retrieveClassMetadata(superclass));
        }
    }

    private Object cloneArray(Class<?> expectedType, Object originalArray, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        int arrayLength = Array.getLength(originalArray);
        if (arrayLength == 0) {
            return originalArray;
        }
        Object cloneArray = Array.newInstance(originalArray.getClass().getComponentType(), arrayLength);
        if (!expectedType.isInstance(cloneArray)) {
            throw new IllegalStateException("The cloneArrayClass (%s) created for originalArrayClass (%s) is not assignable to the field's type (%s).\nMaybe consider replacing the default %s.".formatted(cloneArray.getClass(), originalArray.getClass(), expectedType, SolutionCloner.class.getSimpleName()));
        }
        ClassMetadataReuseHelper reuseHelper = new ClassMetadataReuseHelper(this::retrieveClassMetadata);
        for (int i = 0; i < arrayLength; ++i) {
            Object cloneElement = this.cloneCollectionsElementIfNeeded(Array.get(originalArray, i), originalToCloneMap, unprocessedQueue, reuseHelper);
            Array.set(cloneArray, i, cloneElement);
        }
        return cloneArray;
    }

    private <E> Collection<E> cloneCollection(Class<?> expectedType, Collection<E> originalCollection, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        if (originalCollection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)originalCollection;
            return EnumSet.copyOf(enumSet);
        }
        Collection<E> cloneCollection = FieldAccessingSolutionCloner.constructCloneCollection(originalCollection);
        if (!expectedType.isInstance(cloneCollection)) {
            throw new IllegalStateException("The cloneCollectionClass (%s) created for originalCollectionClass (%s) is not assignable to the field's type (%s).\nMaybe consider replacing the default %s.".formatted(cloneCollection.getClass(), originalCollection.getClass(), expectedType, SolutionCloner.class.getSimpleName()));
        }
        if (originalCollection.isEmpty()) {
            return cloneCollection;
        }
        ClassMetadataReuseHelper reuseHelper = new ClassMetadataReuseHelper(this::retrieveClassMetadata);
        for (E originalElement : originalCollection) {
            E cloneElement = this.cloneCollectionsElementIfNeeded(originalElement, originalToCloneMap, unprocessedQueue, reuseHelper);
            cloneCollection.add(cloneElement);
        }
        return cloneCollection;
    }

    private static <E> Collection<E> constructCloneCollection(Collection<E> originalCollection) {
        if (originalCollection instanceof PlanningCloneable) {
            PlanningCloneable planningCloneable = (PlanningCloneable)((Object)originalCollection);
            return (Collection)planningCloneable.createNewInstance();
        }
        if (originalCollection instanceof LinkedList) {
            return new LinkedList();
        }
        int size = originalCollection.size();
        if (originalCollection instanceof Set) {
            if (originalCollection instanceof SortedSet) {
                SortedSet set = (SortedSet)originalCollection;
                Comparator setComparator = set.comparator();
                return new TreeSet(setComparator);
            }
            if (!(originalCollection instanceof LinkedHashSet)) {
                return CollectionUtils.newHashSet(size);
            }
            return CollectionUtils.newLinkedHashSet(size);
        }
        if (originalCollection instanceof Deque) {
            return new ArrayDeque(size);
        }
        return new ArrayList(size);
    }

    private <K, V> Map<K, V> cloneMap(Class<?> expectedType, Map<K, V> originalMap, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        if (originalMap instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)originalMap;
            EnumMap cloneMap = new EnumMap(enumMap);
            if (cloneMap.isEmpty()) {
                return cloneMap;
            }
            ClassMetadataReuseHelper reuseHelper = new ClassMetadataReuseHelper(this::retrieveClassMetadata);
            for (Map.Entry originalEntry : enumMap.entrySet()) {
                Object cloneValue;
                Object originalValue = originalEntry.getValue();
                if (originalValue == (cloneValue = this.cloneCollectionsElementIfNeeded(originalValue, originalToCloneMap, unprocessedQueue, reuseHelper))) continue;
                cloneMap.put((Enum)originalEntry.getKey(), cloneValue);
            }
            return cloneMap;
        }
        Map<K, V> cloneMap = FieldAccessingSolutionCloner.constructCloneMap(originalMap);
        if (!expectedType.isInstance(cloneMap)) {
            throw new IllegalStateException("The cloneMapClass (%s) created for originalMapClass (%s) is not assignable to the field's type (%s).\nMaybe consider replacing the default %s.".formatted(cloneMap.getClass(), originalMap.getClass(), expectedType, SolutionCloner.class.getSimpleName()));
        }
        if (originalMap.isEmpty()) {
            return cloneMap;
        }
        ClassMetadataReuseHelper keyReuseHelper = new ClassMetadataReuseHelper(this::retrieveClassMetadata);
        ClassMetadataReuseHelper valueReuseHelper = new ClassMetadataReuseHelper(this::retrieveClassMetadata);
        for (Map.Entry<K, V> originalEntry : originalMap.entrySet()) {
            K cloneKey = this.cloneCollectionsElementIfNeeded(originalEntry.getKey(), originalToCloneMap, unprocessedQueue, keyReuseHelper);
            V cloneValue = this.cloneCollectionsElementIfNeeded(originalEntry.getValue(), originalToCloneMap, unprocessedQueue, valueReuseHelper);
            cloneMap.put(cloneKey, cloneValue);
        }
        return cloneMap;
    }

    private static <K, V> Map<K, V> constructCloneMap(Map<K, V> originalMap) {
        if (originalMap instanceof PlanningCloneable) {
            PlanningCloneable planningCloneable = (PlanningCloneable)((Object)originalMap);
            return (Map)planningCloneable.createNewInstance();
        }
        if (originalMap instanceof SortedMap) {
            SortedMap map = (SortedMap)originalMap;
            Comparator setComparator = map.comparator();
            return new TreeMap(setComparator);
        }
        int originalMapSize = originalMap.size();
        if (!(originalMap instanceof LinkedHashMap)) {
            return CollectionUtils.newHashMap(originalMapSize);
        }
        return CollectionUtils.newLinkedHashMap(originalMapSize);
    }

    private ClassMetadata retrieveClassMetadata(Class<?> declaringClass) {
        return this.classMetadataMemoization.computeIfAbsent(declaringClass, this.classMetadataConstructor);
    }

    private <C> C cloneCollectionsElementIfNeeded(C original, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue, ClassMetadataReuseHelper classMetadataReuseHelper) {
        if (original == null) {
            return null;
        }
        if (original instanceof Collection) {
            Collection collection = (Collection)original;
            return (C)this.cloneCollection(Collection.class, collection, originalToCloneMap, unprocessedQueue);
        }
        if (original instanceof Map) {
            Map map = (Map)original;
            return (C)this.cloneMap(Map.class, map, originalToCloneMap, unprocessedQueue);
        }
        if (original.getClass().isArray()) {
            return (C)this.cloneArray(original.getClass(), original, originalToCloneMap, unprocessedQueue);
        }
        ClassMetadata classMetadata = classMetadataReuseHelper.getClassMetadata(original);
        if (classMetadata.isDeepCloned) {
            return this.clone(original, originalToCloneMap, unprocessedQueue, classMetadata);
        }
        return original;
    }

    private void validateCloneSolution(Solution_ originalSolution, Solution_ cloneSolution) {
        for (MemberAccessor memberAccessor : this.solutionDescriptor.getEntityMemberAccessorMap().values()) {
            FieldAccessingSolutionCloner.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
        }
        for (MemberAccessor memberAccessor : this.solutionDescriptor.getEntityCollectionMemberAccessorMap().values()) {
            FieldAccessingSolutionCloner.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
        }
    }

    private static <Solution_> void validateCloneProperty(Solution_ originalSolution, Solution_ cloneSolution, MemberAccessor memberAccessor) {
        Object cloneProperty;
        Object originalProperty = memberAccessor.executeGetter(originalSolution);
        if (originalProperty != null && originalProperty == (cloneProperty = memberAccessor.executeGetter(cloneSolution))) {
            throw new IllegalStateException("The solutionProperty (%s) was not cloned as expected.\nThe %s failed to recognize that property's field, probably because its field name is different.".formatted(memberAccessor.getName(), FieldAccessingSolutionCloner.class.getSimpleName()));
        }
    }

    private static final class ClassMetadata {
        private final SolutionDescriptor<?> solutionDescriptor;
        private final Class<?> declaringClass;
        private final boolean isDeepCloned;
        private volatile MethodHandle constructor = null;
        private volatile ShallowCloningFieldCloner[] copiedFieldArray;
        private volatile DeepCloningFieldCloner[] clonedFieldArray;

        public ClassMetadata(SolutionDescriptor<?> solutionDescriptor, Class<?> declaringClass) {
            this.solutionDescriptor = solutionDescriptor;
            this.declaringClass = declaringClass;
            this.isDeepCloned = DeepCloningUtils.isClassDeepCloned(solutionDescriptor, declaringClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MethodHandle getConstructor() {
            if (this.constructor == null) {
                ClassMetadata classMetadata = this;
                synchronized (classMetadata) {
                    if (this.constructor == null) {
                        try {
                            Constructor<?> ctor = this.declaringClass.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            this.constructor = MethodHandles.lookup().unreflectConstructor(ctor);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new IllegalStateException("To create a planning clone, the class (%s) must have a no-arg constructor.".formatted(this.declaringClass.getCanonicalName()), e);
                        }
                    }
                }
            }
            return this.constructor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ShallowCloningFieldCloner[] getCopiedFieldArray() {
            if (this.copiedFieldArray == null) {
                ClassMetadata classMetadata = this;
                synchronized (classMetadata) {
                    if (this.copiedFieldArray == null) {
                        this.copiedFieldArray = (ShallowCloningFieldCloner[])Arrays.stream(this.declaringClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(field -> DeepCloningUtils.isImmutable(field.getType())).peek(f -> {
                            if (DeepCloningUtils.needsDeepClone(this.solutionDescriptor, f, this.declaringClass)) {
                                throw new IllegalStateException("The field (%s) of class (%s) needs to be deep-cloned,\nbut its type (%s) is immutable and can not be deep-cloned.\nMaybe remove the @%s annotation from the field?\nMaybe do not reference planning entities inside Java records?".formatted(f.getName(), this.declaringClass.getCanonicalName(), f.getType().getCanonicalName(), DeepPlanningClone.class.getSimpleName()));
                            }
                        }).map(ShallowCloningFieldCloner::of).toArray(ShallowCloningFieldCloner[]::new);
                    }
                }
            }
            return this.copiedFieldArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DeepCloningFieldCloner[] getClonedFieldArray() {
            if (this.clonedFieldArray == null) {
                ClassMetadata classMetadata = this;
                synchronized (classMetadata) {
                    if (this.clonedFieldArray == null) {
                        this.clonedFieldArray = (DeepCloningFieldCloner[])Arrays.stream(this.declaringClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(field -> !DeepCloningUtils.isImmutable(field.getType())).map(DeepCloningFieldCloner::new).toArray(DeepCloningFieldCloner[]::new);
                    }
                }
            }
            return this.clonedFieldArray;
        }
    }

    private record Unprocessed(Object bean, DeepCloningFieldCloner cloner, Object originalValue) {
    }

    private static final class ClassMetadataReuseHelper {
        private final Function<Class<?>, ClassMetadata> classMetadataFunction;
        private Object previousClass;
        private ClassMetadata previousClassMetadata;

        public ClassMetadataReuseHelper(Function<Class<?>, ClassMetadata> classMetadataFunction) {
            this.classMetadataFunction = classMetadataFunction;
        }

        public @NonNull ClassMetadata getClassMetadata(@NonNull Object object) {
            Class<?> clazz = object.getClass();
            if (clazz != this.previousClass) {
                this.previousClass = clazz;
                this.previousClassMetadata = this.classMetadataFunction.apply(clazz);
            }
            return this.previousClassMetadata;
        }
    }
}

