/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner;

import ai.timefold.solver.core.impl.domain.common.accessor.FieldHandle;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

final class DeepCloningFieldCloner {
    private final AtomicReference<Metadata> valueDeepCloneDecision = new AtomicReference();
    private final AtomicInteger fieldDeepCloneDecision = new AtomicInteger(-1);
    private final FieldHandle fieldHandle;

    public DeepCloningFieldCloner(Field field) {
        this.fieldHandle = FieldHandle.of(Objects.requireNonNull(field));
    }

    public FieldHandle getFieldHandles() {
        return this.fieldHandle;
    }

    public <C> Object clone(SolutionDescriptor<?> solutionDescriptor, C original, C clone) {
        Object originalValue = FieldCloningUtils.getObjectFieldValue(original, this.fieldHandle);
        if (this.deepClone(solutionDescriptor, original.getClass(), originalValue)) {
            return originalValue;
        }
        FieldCloningUtils.setObjectFieldValue(clone, this.fieldHandle, originalValue);
        return null;
    }

    private boolean deepClone(SolutionDescriptor<?> solutionDescriptor, Class<?> fieldTypeClass, Object originalValue) {
        if (originalValue == null) {
            return false;
        }
        boolean isValueDeepCloned = this.valueDeepCloneDecision.updateAndGet((UnaryOperator<Metadata>)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deepClone$0(java.lang.Object ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningFieldCloner$Metadata ), (Lai/timefold/solver/core/impl/domain/solution/cloner/DeepCloningFieldCloner$Metadata;)Lai/timefold/solver/core/impl/domain/solution/cloner/DeepCloningFieldCloner$Metadata;)((Object)originalValue, solutionDescriptor)).decision;
        if (isValueDeepCloned) {
            return true;
        }
        if (this.fieldDeepCloneDecision.get() < 0) {
            this.fieldDeepCloneDecision.set(DeepCloningUtils.isFieldDeepCloned(solutionDescriptor, this.getFieldHandles().field(), fieldTypeClass) ? 1 : 0);
        }
        return this.fieldDeepCloneDecision.get() == 1;
    }

    private static /* synthetic */ Metadata lambda$deepClone$0(Object originalValue, SolutionDescriptor solutionDescriptor, Metadata old) {
        Class<?> originalClass = originalValue.getClass();
        if (old == null || old.clz != originalClass) {
            return new Metadata(originalClass, DeepCloningUtils.isClassDeepCloned(solutionDescriptor, originalClass));
        }
        return old;
    }

    private record Metadata(Class<?> clz, boolean decision) {
    }
}

