/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintWeight;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true, since="1.13.0")
final class ConstraintConfigurationDescriptor<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Class<?> constraintConfigurationClass;
    private String constraintPackage;
    private final Map<String, ConstraintWeightDescriptor<Solution_>> constraintWeightDescriptorMap;

    public ConstraintConfigurationDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> constraintConfigurationClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintConfigurationClass = constraintConfigurationClass;
        this.constraintWeightDescriptorMap = new LinkedHashMap<String, ConstraintWeightDescriptor<Solution_>>();
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public ConstraintWeightDescriptor<Solution_> getConstraintWeightDescriptor(String propertyName) {
        return this.constraintWeightDescriptorMap.get(propertyName);
    }

    public void processAnnotations(MemberAccessorFactory memberAccessorFactory, DomainAccessType domainAccessType, ScoreDefinition<?> scoreDefinition) {
        this.processPackAnnotation();
        ArrayList potentiallyOverwritingMethodList = new ArrayList();
        for (Class<?> lineageClass : ConfigUtils.getAllAnnotatedLineageClasses(this.constraintConfigurationClass, ConstraintConfiguration.class)) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            for (Member member2 : memberList) {
                if (member2 instanceof Method) {
                    Method method = (Method)member2;
                    if (potentiallyOverwritingMethodList.stream().anyMatch(m -> member2.getName().equals(m.getName()) && ReflectionHelper.isMethodOverwritten(method, m.getDeclaringClass()))) continue;
                }
                this.processParameterAnnotation(memberAccessorFactory, domainAccessType, member2, scoreDefinition);
            }
            potentiallyOverwritingMethodList.ensureCapacity(potentiallyOverwritingMethodList.size() + memberList.size());
            memberList.stream().filter(Method.class::isInstance).forEach(member -> potentiallyOverwritingMethodList.add((Method)member));
        }
        if (this.constraintWeightDescriptorMap.isEmpty()) {
            throw new IllegalStateException("The constraintConfigurationClass (" + String.valueOf(this.constraintConfigurationClass) + ") must have at least 1 member with a " + ConstraintWeight.class.getSimpleName() + " annotation.");
        }
    }

    private void processPackAnnotation() {
        ConstraintConfiguration packAnnotation = this.constraintConfigurationClass.getAnnotation(ConstraintConfiguration.class);
        if (packAnnotation == null) {
            throw new IllegalStateException("The constraintConfigurationClass (" + String.valueOf(this.constraintConfigurationClass) + ") has been specified as a @" + ConstraintConfigurationProvider.class.getSimpleName() + " in the solution class (" + String.valueOf(this.solutionDescriptor.getSolutionClass()) + "), but does not have a @" + ConstraintConfiguration.class.getSimpleName() + " annotation.");
        }
        this.constraintPackage = packAnnotation.constraintPackage();
        if (this.constraintPackage.isEmpty()) {
            Package pack = this.constraintConfigurationClass.getPackage();
            this.constraintPackage = pack == null ? "" : pack.getName();
        }
    }

    private void processParameterAnnotation(MemberAccessorFactory memberAccessorFactory, DomainAccessType domainAccessType, Member member, ScoreDefinition<?> scoreDefinition) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ConstraintWeight.class)) {
            MemberAccessor memberAccessor = memberAccessorFactory.buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ConstraintWeight.class, domainAccessType);
            if (this.constraintWeightDescriptorMap.containsKey(memberAccessor.getName())) {
                MemberAccessor duplicate = this.constraintWeightDescriptorMap.get(memberAccessor.getName()).getMemberAccessor();
                throw new IllegalStateException("The constraintConfigurationClass (" + String.valueOf(this.constraintConfigurationClass) + ") has a @" + ConstraintWeight.class.getSimpleName() + " annotated member (" + String.valueOf(memberAccessor) + ") that is duplicated by a member (" + String.valueOf(duplicate) + ").\nMaybe the annotation is defined on both the field and its getter.");
            }
            if (!scoreDefinition.getScoreClass().isAssignableFrom(memberAccessor.getType())) {
                throw new IllegalStateException("The constraintConfigurationClass (" + String.valueOf(this.constraintConfigurationClass) + ") has a @" + ConstraintWeight.class.getSimpleName() + " annotated member (" + String.valueOf(memberAccessor) + ") with a return type (" + String.valueOf(memberAccessor.getType()) + ") that is not assignable to the score class (" + String.valueOf(scoreDefinition.getScoreClass()) + ").\nMaybe make that member (" + memberAccessor.getName() + ") return the score class (" + scoreDefinition.getScoreClass().getSimpleName() + ") instead.");
            }
            ConstraintWeightDescriptor constraintWeightDescriptor = new ConstraintWeightDescriptor(memberAccessor);
            this.constraintWeightDescriptorMap.put(memberAccessor.getName(), constraintWeightDescriptor);
        }
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getConstraintConfigurationClass() {
        return this.constraintConfigurationClass;
    }

    public Set<ConstraintRef> getSupportedConstraints() {
        return this.constraintWeightDescriptorMap.values().stream().map(ConstraintWeightDescriptor::getConstraintRef).collect(Collectors.toSet());
    }

    public ConstraintWeightDescriptor<Solution_> findConstraintWeightDescriptor(ConstraintRef constraintRef) {
        return this.constraintWeightDescriptorMap.values().stream().filter(constraintWeightDescriptor -> constraintWeightDescriptor.getConstraintRef().equals(constraintRef)).findFirst().orElse(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.constraintConfigurationClass.getName() + ")";
    }
}

