/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.impl.domain.common.accessor.AbstractMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.FieldHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public final class ReflectionFieldMemberAccessor
extends AbstractMemberAccessor {
    private final FieldHandle fieldHandle;

    public ReflectionFieldMemberAccessor(Field field) {
        this.fieldHandle = FieldHandle.of(field);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.fieldHandle.field().getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.fieldHandle.field().getName();
    }

    @Override
    public Class<?> getType() {
        return this.fieldHandle.field().getType();
    }

    @Override
    public Type getGenericType() {
        return this.fieldHandle.field().getGenericType();
    }

    @Override
    public Object executeGetter(Object bean) {
        Field field = this.fieldHandle.field();
        if (bean == null) {
            throw new IllegalArgumentException("Requested field (%s) on a null bean.".formatted(field));
        }
        return this.fieldHandle.get(bean);
    }

    @Override
    public boolean supportSetter() {
        return true;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        Field field = this.fieldHandle.field();
        if (bean == null) {
            throw new IllegalArgumentException("Requested field (%s) on a null bean.".formatted(field));
        }
        this.fieldHandle.set(bean, value);
    }

    @Override
    public String getSpeedNote() {
        return "reflection";
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.fieldHandle.field().getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.fieldHandle.field().getDeclaredAnnotationsByType(annotationClass);
    }

    public String toString() {
        return "field " + String.valueOf(this.fieldHandle.field());
    }
}

