/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.AbstractMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.function.IntPredicate;

public final class ReflectionBeanPropertyMemberAccessor
extends AbstractMemberAccessor {
    private final Class<?> propertyType;
    private final String propertyName;
    private final Method getterMethod;
    private final MethodHandle getherMethodHandle;
    private final Method setterMethod;
    private final MethodHandle setterMethodHandle;

    public ReflectionBeanPropertyMemberAccessor(Method getterMethod) {
        this(getterMethod, false);
    }

    public ReflectionBeanPropertyMemberAccessor(Method getterMethod, boolean getterOnly) {
        this.getterMethod = getterMethod;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            getterMethod.setAccessible(true);
            this.getherMethodHandle = lookup.unreflect(getterMethod).asFixedArity();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Impossible state: method (%s) not accessible.\n%s".formatted(getterMethod, MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE), e);
        }
        Class<?> declaringClass = getterMethod.getDeclaringClass();
        if (!ReflectionHelper.isGetterMethod(getterMethod)) {
            throw new IllegalArgumentException("The getterMethod (%s) is not a valid getter.".formatted(getterMethod));
        }
        this.propertyType = getterMethod.getReturnType();
        this.propertyName = ReflectionHelper.getGetterPropertyName(getterMethod);
        if (getterOnly) {
            this.setterMethod = null;
            this.setterMethodHandle = null;
        } else {
            AccessModifier setterAccess;
            this.setterMethod = ReflectionHelper.getDeclaredSetterMethod(declaringClass, getterMethod.getReturnType(), this.propertyName);
            if (this.setterMethod == null) {
                throw new IllegalArgumentException("The getterMethod (%s) does not have a matching setterMethod on class (%s).".formatted(getterMethod.getName(), declaringClass.getCanonicalName()));
            }
            AccessModifier getterAccess = AccessModifier.forMethod(getterMethod);
            if (getterAccess != (setterAccess = AccessModifier.forMethod(this.setterMethod))) {
                throw new IllegalArgumentException("The getterMethod (%s) has access modifier (%s) which does not match the setterMethod (%s) access modifier (%s) on class (%s).".formatted(new Object[]{getterMethod.getName(), getterAccess, this.setterMethod.getName(), setterAccess, declaringClass.getCanonicalName()}));
            }
            try {
                this.setterMethod.setAccessible(true);
                this.setterMethodHandle = lookup.unreflect(this.setterMethod).asFixedArity();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Impossible state: method (%s) not accessible.\n%s".formatted(this.setterMethod, MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE), e);
            }
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getterMethod.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Class<?> getType() {
        return this.propertyType;
    }

    @Override
    public Type getGenericType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public Object executeGetter(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Requested property (%s) getterMethod (%s) on a null bean.".formatted(this.propertyName, this.getterMethod));
        }
        try {
            return this.getherMethodHandle.invoke(bean);
        }
        catch (Throwable e) {
            throw new IllegalStateException("The property (%s) getterMethod (%s) on bean of class (%s) throws an exception.".formatted(this.propertyName, this.getterMethod, bean.getClass()), e);
        }
    }

    @Override
    public boolean supportSetter() {
        return this.setterMethod != null;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        if (bean == null) {
            throw new IllegalArgumentException("Requested property (%s) setterMethod (%s) on a null bean.".formatted(this.propertyName, this.setterMethod));
        }
        try {
            this.setterMethodHandle.invoke(bean, value);
        }
        catch (Throwable e) {
            throw new IllegalStateException("The property (%s) setterMethod (%s) on bean of class (%s) throws an exception.".formatted(this.propertyName, this.setterMethod, bean.getClass()), e);
        }
    }

    @Override
    public String getSpeedNote() {
        return "MethodHandle";
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getterMethod.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getterMethod.getDeclaredAnnotationsByType(annotationClass);
    }

    public String toString() {
        return "bean property " + this.propertyName + " on " + String.valueOf(this.getterMethod.getDeclaringClass());
    }

    private static enum AccessModifier {
        PUBLIC("public", Modifier::isPublic),
        PROTECTED("protected", Modifier::isProtected),
        PACKAGE_PRIVATE("package-private", modifier -> false),
        PRIVATE("private", Modifier::isPrivate);

        final String name;
        final IntPredicate predicate;

        private AccessModifier(String name, IntPredicate predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        public static AccessModifier forMethod(Method method) {
            int modifiers = method.getModifiers();
            for (AccessModifier accessModifier : AccessModifier.values()) {
                if (!accessModifier.predicate.test(modifiers)) continue;
                return accessModifier;
            }
            return PACKAGE_PRIVATE;
        }

        public String toString() {
            return this.name;
        }
    }
}

