/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.tuple;

import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;
import java.util.function.Predicate;

public record ConditionalTupleLifecycle<Tuple_ extends AbstractTuple>(TupleLifecycle<Tuple_> downstreamLifecycle, TuplePredicate<Tuple_> predicate) implements TupleLifecycle<Tuple_>
{
    public ConditionalTupleLifecycle {
        Objects.requireNonNull(downstreamLifecycle);
        Objects.requireNonNull(predicate);
    }

    @Override
    public void insert(Tuple_ tuple) {
        if (this.predicate.test(tuple)) {
            this.downstreamLifecycle.insert(tuple);
        }
    }

    @Override
    public void update(Tuple_ tuple) {
        if (this.predicate.test(tuple)) {
            this.downstreamLifecycle.update(tuple);
        } else {
            this.downstreamLifecycle.retract(tuple);
        }
    }

    @Override
    public void retract(Tuple_ tuple) {
        this.downstreamLifecycle.retract(tuple);
    }

    @Override
    public String toString() {
        return "Conditional %s".formatted(this.downstreamLifecycle);
    }

    @FunctionalInterface
    static interface TuplePredicate<Tuple_ extends AbstractTuple>
    extends Predicate<Tuple_> {
    }
}

