/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.KeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.ManyKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.NoneIndexer;
import ai.timefold.solver.core.impl.bavet.common.index.SingleKeyRetriever;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class EqualsIndexer<T, Key_>
implements Indexer<T> {
    private final KeyRetriever<Key_> keyRetriever;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Map<Key_, Indexer<T>> downstreamIndexerMap = new HashMap<Key_, Indexer<T>>();

    public EqualsIndexer() {
        this.keyRetriever = new SingleKeyRetriever();
        this.downstreamIndexerSupplier = NoneIndexer::new;
    }

    public EqualsIndexer(int keyIndex, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.keyRetriever = new ManyKeyRetriever(keyIndex);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
    }

    @Override
    public ElementAwareListEntry<T> put(Object indexKeys, T tuple) {
        Object indexKey = this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.downstreamIndexerMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(indexKeys, tuple);
    }

    @Override
    public void remove(Object indexKeys, ElementAwareListEntry<T> entry) {
        Object indexKey = this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(indexKeys, indexKey, entry);
        downstreamIndexer.remove(indexKeys, entry);
        if (downstreamIndexer.isEmpty()) {
            this.downstreamIndexerMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(Object indexKeys, Key_ indexerKey, ElementAwareListEntry<T> entry) {
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (%s) with indexKey (%s) doesn't exist in the indexer %s.".formatted(entry.getElement(), indexKeys, this));
        }
        return downstreamIndexer;
    }

    @Override
    public int size(Object indexKeys) {
        Object indexKey = this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return 0;
        }
        return downstreamIndexer.size(indexKeys);
    }

    @Override
    public void forEach(Object indexKeys, Consumer<T> tupleConsumer) {
        Object indexKey = this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return;
        }
        downstreamIndexer.forEach(indexKeys, tupleConsumer);
    }

    @Override
    public boolean isEmpty() {
        return this.downstreamIndexerMap.isEmpty();
    }

    public String toString() {
        return "size = " + this.downstreamIndexerMap.size();
    }
}

