/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;

public abstract class AbstractUnindexedIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightEntry;
    private final ElementAwareList<ExistsCounter<LeftTuple_>> leftCounterList = new ElementAwareList();
    private final ElementAwareList<UniTuple<Right_>> rightTupleList = new ElementAwareList();

    protected AbstractUnindexedIfExistsNode(boolean shouldExist, int inputStoreIndexLeftCounterEntry, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightEntry, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering) {
        super(shouldExist, inputStoreIndexLeftTrackerList, inputStoreIndexRightTrackerList, nextNodesTupleLifecycle, isFiltering);
        this.inputStoreIndexLeftCounterEntry = inputStoreIndexLeftCounterEntry;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(leftTuple) + ") was already added in the tupleStore.");
        }
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry = this.leftCounterList.add(counter);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.rightTupleList.size();
        } else {
            ElementAwareList leftTrackerList = new ElementAwareList();
            for (UniTuple<Right_> tuple : this.rightTupleList) {
                this.updateCounterFromLeft(leftTuple, tuple, counter, leftTrackerList);
            }
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
        this.initCounterLeft(counter);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        ElementAwareListEntry counterEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            this.insertLeft(leftTuple);
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (!this.isFiltering) {
            this.updateUnchangedCounterLeft(counter);
        } else {
            ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
            counter.countRight = 0;
            for (UniTuple<Right_> tuple : this.rightTupleList) {
                this.updateCounterFromLeft(leftTuple, tuple, counter, leftTrackerList);
            }
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        ElementAwareListEntry counterEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        counterEntry.remove();
        if (this.isFiltering) {
            ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
        }
        this.killCounterLeft(counter);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(rightTuple) + ") was already added in the tupleStore.");
        }
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.rightTupleList.add(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        if (!this.isFiltering) {
            this.leftCounterList.forEach(this::incrementCounterRight);
        } else {
            ElementAwareList rightTrackerList = new ElementAwareList();
            for (ExistsCounter<LeftTuple_> tuple : this.leftCounterList) {
                this.updateCounterFromRight(rightTuple, tuple, rightTrackerList);
            }
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            this.insertRight(rightTuple);
            return;
        }
        if (this.isFiltering) {
            ElementAwareList rightTrackerList = this.updateRightTrackerList(rightTuple);
            for (ExistsCounter<LeftTuple_> tuple : this.leftCounterList) {
                this.updateCounterFromRight(rightTuple, tuple, rightTrackerList);
            }
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        rightEntry.remove();
        if (!this.isFiltering) {
            this.leftCounterList.forEach(this::decrementCounterRight);
        } else {
            this.updateRightTrackerList(rightTuple);
        }
    }
}

