/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.bi;

import ai.timefold.solver.core.impl.bavet.common.AbstractConcatNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import java.util.function.Function;

public final class ConcatUniBiNode<A, B>
extends AbstractConcatNode<UniTuple<A>, BiTuple<A, B>, BiTuple<A, B>> {
    private final Function<A, B> paddingFunction;

    public ConcatUniBiNode(Function<A, B> paddingFunction, TupleLifecycle<BiTuple<A, B>> nextNodesTupleLifecycle, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightOutTupleList, int outputStoreSize) {
        super(nextNodesTupleLifecycle, inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, outputStoreSize);
        this.paddingFunction = paddingFunction;
    }

    @Override
    protected BiTuple<A, B> getOutTupleFromLeft(UniTuple<A> leftTuple) {
        Object factA = leftTuple.factA;
        return new BiTuple(factA, this.paddingFunction.apply(factA), this.outputStoreSize);
    }

    @Override
    protected BiTuple<A, B> getOutTupleFromRight(BiTuple<A, B> rightTuple) {
        return new BiTuple(rightTuple.factA, rightTuple.factB, this.outputStoreSize);
    }

    @Override
    protected void updateOutTupleFromLeft(UniTuple<A> leftTuple, BiTuple<A, B> outTuple) {
        outTuple.factA = leftTuple.factA;
    }

    @Override
    protected void updateOutTupleFromRight(BiTuple<A, B> rightTuple, BiTuple<A, B> outTuple) {
        outTuple.factA = rightTuple.factA;
        outTuple.factB = rightTuple.factB;
    }
}

