/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"minimumRuinedCount", "maximumRuinedCount", "minimumRuinedPercentage", "maximumRuinedPercentage"})
public class ListRuinRecreateMoveSelectorConfig
extends MoveSelectorConfig<ListRuinRecreateMoveSelectorConfig> {
    private static final int DEFAULT_MINIMUM_RUINED_COUNT = 5;
    private static final int DEFAULT_MAXIMUM_RUINED_COUNT = 40;
    public static final String XML_ELEMENT_NAME = "listRuinRecreateMoveSelector";
    protected Integer minimumRuinedCount = null;
    protected Integer maximumRuinedCount = null;
    protected Double minimumRuinedPercentage = null;
    protected Double maximumRuinedPercentage = null;

    public @Nullable Integer getMinimumRuinedCount() {
        return this.minimumRuinedCount;
    }

    public void setMinimumRuinedCount(@Nullable Integer minimumRuinedCount) {
        this.minimumRuinedCount = minimumRuinedCount;
    }

    public @NonNull ListRuinRecreateMoveSelectorConfig withMinimumRuinedCount(@NonNull Integer minimumRuinedCount) {
        this.minimumRuinedCount = minimumRuinedCount;
        return this;
    }

    public @Nullable Integer getMaximumRuinedCount() {
        return this.maximumRuinedCount;
    }

    public void setMaximumRuinedCount(@Nullable Integer maximumRuinedCount) {
        this.maximumRuinedCount = maximumRuinedCount;
    }

    public @NonNull ListRuinRecreateMoveSelectorConfig withMaximumRuinedCount(@NonNull Integer maximumRuinedCount) {
        this.maximumRuinedCount = maximumRuinedCount;
        return this;
    }

    public @Nullable Double getMinimumRuinedPercentage() {
        return this.minimumRuinedPercentage;
    }

    public void setMinimumRuinedPercentage(@Nullable Double minimumRuinedPercentage) {
        this.minimumRuinedPercentage = minimumRuinedPercentage;
    }

    public @NonNull ListRuinRecreateMoveSelectorConfig withMinimumRuinedPercentage(@NonNull Double minimumRuinedPercentage) {
        this.minimumRuinedPercentage = minimumRuinedPercentage;
        return this;
    }

    public @Nullable Double getMaximumRuinedPercentage() {
        return this.maximumRuinedPercentage;
    }

    public void setMaximumRuinedPercentage(@Nullable Double maximumRuinedPercentage) {
        this.maximumRuinedPercentage = maximumRuinedPercentage;
    }

    public @NonNull ListRuinRecreateMoveSelectorConfig withMaximumRuinedPercentage(@NonNull Double maximumRuinedPercentage) {
        this.maximumRuinedPercentage = maximumRuinedPercentage;
        return this;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return false;
    }

    @Override
    public @NonNull ListRuinRecreateMoveSelectorConfig copyConfig() {
        return new ListRuinRecreateMoveSelectorConfig().inherit(this);
    }

    @Override
    public @NonNull ListRuinRecreateMoveSelectorConfig inherit(@NonNull ListRuinRecreateMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.minimumRuinedCount = ConfigUtils.inheritOverwritableProperty(this.minimumRuinedCount, inheritedConfig.getMinimumRuinedCount());
        this.maximumRuinedCount = ConfigUtils.inheritOverwritableProperty(this.maximumRuinedCount, inheritedConfig.getMaximumRuinedCount());
        this.minimumRuinedPercentage = ConfigUtils.inheritOverwritableProperty(this.minimumRuinedPercentage, inheritedConfig.getMinimumRuinedPercentage());
        this.maximumRuinedPercentage = ConfigUtils.inheritOverwritableProperty(this.maximumRuinedPercentage, inheritedConfig.getMaximumRuinedPercentage());
        return this;
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
    }

    public int determineMinimumRuinedCount(long valueCount) {
        if (this.minimumRuinedCount != null) {
            return this.minimumRuinedCount;
        }
        if (this.minimumRuinedPercentage != null) {
            return (int)Math.floor(this.minimumRuinedPercentage * (double)valueCount);
        }
        return (int)Math.min(5L, valueCount);
    }

    public int determineMaximumRuinedCount(long valueCount) {
        if (this.maximumRuinedCount != null) {
            return this.maximumRuinedCount;
        }
        if (this.maximumRuinedPercentage != null) {
            return (int)Math.floor(this.maximumRuinedPercentage * (double)valueCount);
        }
        return (int)Math.min(40L, valueCount);
    }
}

