/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.common.nearby;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionDistributionType;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"originEntitySelectorConfig", "originSubListSelectorConfig", "originValueSelectorConfig", "nearbyDistanceMeterClass", "nearbySelectionDistributionType", "blockDistributionSizeMinimum", "blockDistributionSizeMaximum", "blockDistributionSizeRatio", "blockDistributionUniformDistributionProbability", "linearDistributionSizeMaximum", "parabolicDistributionSizeMaximum", "betaDistributionAlpha", "betaDistributionBeta"})
public class NearbySelectionConfig
extends SelectorConfig<NearbySelectionConfig> {
    @XmlElement(name="originEntitySelector")
    protected EntitySelectorConfig originEntitySelectorConfig = null;
    @XmlElement(name="originSubListSelector")
    protected SubListSelectorConfig originSubListSelectorConfig = null;
    @XmlElement(name="originValueSelector")
    protected ValueSelectorConfig originValueSelectorConfig = null;
    protected Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass = null;
    protected NearbySelectionDistributionType nearbySelectionDistributionType = null;
    protected Integer blockDistributionSizeMinimum = null;
    protected Integer blockDistributionSizeMaximum = null;
    protected Double blockDistributionSizeRatio = null;
    protected Double blockDistributionUniformDistributionProbability = null;
    protected Integer linearDistributionSizeMaximum = null;
    protected Integer parabolicDistributionSizeMaximum = null;
    protected Double betaDistributionAlpha = null;
    protected Double betaDistributionBeta = null;

    public @Nullable EntitySelectorConfig getOriginEntitySelectorConfig() {
        return this.originEntitySelectorConfig;
    }

    public void setOriginEntitySelectorConfig(@Nullable EntitySelectorConfig originEntitySelectorConfig) {
        this.originEntitySelectorConfig = originEntitySelectorConfig;
    }

    public @Nullable SubListSelectorConfig getOriginSubListSelectorConfig() {
        return this.originSubListSelectorConfig;
    }

    public void setOriginSubListSelectorConfig(@Nullable SubListSelectorConfig originSubListSelectorConfig) {
        this.originSubListSelectorConfig = originSubListSelectorConfig;
    }

    public @Nullable ValueSelectorConfig getOriginValueSelectorConfig() {
        return this.originValueSelectorConfig;
    }

    public void setOriginValueSelectorConfig(@Nullable ValueSelectorConfig originValueSelectorConfig) {
        this.originValueSelectorConfig = originValueSelectorConfig;
    }

    public @Nullable Class<? extends NearbyDistanceMeter> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(@Nullable Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    public @Nullable NearbySelectionDistributionType getNearbySelectionDistributionType() {
        return this.nearbySelectionDistributionType;
    }

    public void setNearbySelectionDistributionType(@Nullable NearbySelectionDistributionType nearbySelectionDistributionType) {
        this.nearbySelectionDistributionType = nearbySelectionDistributionType;
    }

    public @Nullable Integer getBlockDistributionSizeMinimum() {
        return this.blockDistributionSizeMinimum;
    }

    public void setBlockDistributionSizeMinimum(@Nullable Integer blockDistributionSizeMinimum) {
        this.blockDistributionSizeMinimum = blockDistributionSizeMinimum;
    }

    public @Nullable Integer getBlockDistributionSizeMaximum() {
        return this.blockDistributionSizeMaximum;
    }

    public void setBlockDistributionSizeMaximum(@Nullable Integer blockDistributionSizeMaximum) {
        this.blockDistributionSizeMaximum = blockDistributionSizeMaximum;
    }

    public @Nullable Double getBlockDistributionSizeRatio() {
        return this.blockDistributionSizeRatio;
    }

    public void setBlockDistributionSizeRatio(@Nullable Double blockDistributionSizeRatio) {
        this.blockDistributionSizeRatio = blockDistributionSizeRatio;
    }

    public @Nullable Double getBlockDistributionUniformDistributionProbability() {
        return this.blockDistributionUniformDistributionProbability;
    }

    public void setBlockDistributionUniformDistributionProbability(@Nullable Double blockDistributionUniformDistributionProbability) {
        this.blockDistributionUniformDistributionProbability = blockDistributionUniformDistributionProbability;
    }

    public @Nullable Integer getLinearDistributionSizeMaximum() {
        return this.linearDistributionSizeMaximum;
    }

    public void setLinearDistributionSizeMaximum(@Nullable Integer linearDistributionSizeMaximum) {
        this.linearDistributionSizeMaximum = linearDistributionSizeMaximum;
    }

    public @Nullable Integer getParabolicDistributionSizeMaximum() {
        return this.parabolicDistributionSizeMaximum;
    }

    public void setParabolicDistributionSizeMaximum(@Nullable Integer parabolicDistributionSizeMaximum) {
        this.parabolicDistributionSizeMaximum = parabolicDistributionSizeMaximum;
    }

    public @Nullable Double getBetaDistributionAlpha() {
        return this.betaDistributionAlpha;
    }

    public void setBetaDistributionAlpha(@Nullable Double betaDistributionAlpha) {
        this.betaDistributionAlpha = betaDistributionAlpha;
    }

    public @Nullable Double getBetaDistributionBeta() {
        return this.betaDistributionBeta;
    }

    public void setBetaDistributionBeta(@Nullable Double betaDistributionBeta) {
        this.betaDistributionBeta = betaDistributionBeta;
    }

    public @NonNull NearbySelectionConfig withOriginEntitySelectorConfig(@NonNull EntitySelectorConfig originEntitySelectorConfig) {
        this.setOriginEntitySelectorConfig(originEntitySelectorConfig);
        return this;
    }

    public @NonNull NearbySelectionConfig withOriginSubListSelectorConfig(@NonNull SubListSelectorConfig originSubListSelectorConfig) {
        this.setOriginSubListSelectorConfig(originSubListSelectorConfig);
        return this;
    }

    public @NonNull NearbySelectionConfig withOriginValueSelectorConfig(@NonNull ValueSelectorConfig originValueSelectorConfig) {
        this.setOriginValueSelectorConfig(originValueSelectorConfig);
        return this;
    }

    public @NonNull NearbySelectionConfig withNearbyDistanceMeterClass(@NonNull Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.setNearbyDistanceMeterClass(nearbyDistanceMeterClass);
        return this;
    }

    public @NonNull NearbySelectionConfig withNearbySelectionDistributionType(@NonNull NearbySelectionDistributionType nearbySelectionDistributionType) {
        this.setNearbySelectionDistributionType(nearbySelectionDistributionType);
        return this;
    }

    public @NonNull NearbySelectionConfig withBlockDistributionSizeMinimum(@NonNull Integer blockDistributionSizeMinimum) {
        this.setBlockDistributionSizeMinimum(blockDistributionSizeMinimum);
        return this;
    }

    public @NonNull NearbySelectionConfig withBlockDistributionSizeMaximum(@NonNull Integer blockDistributionSizeMaximum) {
        this.setBlockDistributionSizeMaximum(blockDistributionSizeMaximum);
        return this;
    }

    public @NonNull NearbySelectionConfig withBlockDistributionSizeRatio(@NonNull Double blockDistributionSizeRatio) {
        this.setBlockDistributionSizeRatio(blockDistributionSizeRatio);
        return this;
    }

    public @NonNull NearbySelectionConfig withBlockDistributionUniformDistributionProbability(@NonNull Double blockDistributionUniformDistributionProbability) {
        this.setBlockDistributionUniformDistributionProbability(blockDistributionUniformDistributionProbability);
        return this;
    }

    public @NonNull NearbySelectionConfig withLinearDistributionSizeMaximum(@NonNull Integer linearDistributionSizeMaximum) {
        this.setLinearDistributionSizeMaximum(linearDistributionSizeMaximum);
        return this;
    }

    public @NonNull NearbySelectionConfig withParabolicDistributionSizeMaximum(@NonNull Integer parabolicDistributionSizeMaximum) {
        this.setParabolicDistributionSizeMaximum(parabolicDistributionSizeMaximum);
        return this;
    }

    public @NonNull NearbySelectionConfig withBetaDistributionAlpha(@NonNull Double betaDistributionAlpha) {
        this.setBetaDistributionAlpha(betaDistributionAlpha);
        return this;
    }

    public @NonNull NearbySelectionConfig withBetaDistributionBeta(@NonNull Double betaDistributionBeta) {
        this.setBetaDistributionBeta(betaDistributionBeta);
        return this;
    }

    public void validateNearby(@NonNull SelectionCacheType resolvedCacheType, @NonNull SelectionOrder resolvedSelectionOrder) {
        long originSelectorCount = Stream.of(this.originEntitySelectorConfig, this.originSubListSelectorConfig, this.originValueSelectorConfig).filter(Objects::nonNull).count();
        if (originSelectorCount == 0L) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) is nearby selection but lacks an origin selector config.\nSet one of originEntitySelectorConfig, originSubListSelectorConfig or originValueSelectorConfig.".formatted(this));
        }
        if (originSelectorCount > 1L) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) has multiple origin selector configs but exactly one is expected.\nSet one of originEntitySelectorConfig, originSubListSelectorConfig or originValueSelectorConfig.".formatted(this));
        }
        if (this.originEntitySelectorConfig != null && this.originEntitySelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) has an originEntitySelectorConfig (%s) which has no mimicSelectorRef (%s).\nNearby selection's original entity should always be the same as an entity selected earlier in the move.".formatted(this, this.originEntitySelectorConfig, this.originEntitySelectorConfig.getMimicSelectorRef()));
        }
        if (this.originSubListSelectorConfig != null && this.originSubListSelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) has an originSubListSelectorConfig (%s) which has no mimicSelectorRef (%s).\nNearby selection's original subList should always be the same as a subList selected earlier in the move.".formatted(this, this.originSubListSelectorConfig, this.originSubListSelectorConfig.getMimicSelectorRef()));
        }
        if (this.originValueSelectorConfig != null && this.originValueSelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) has an originValueSelectorConfig (%s) which has no mimicSelectorRef (%s).\nNearby selection's original value should always be the same as a value selected earlier in the move.".formatted(this, this.originValueSelectorConfig, this.originValueSelectorConfig.getMimicSelectorRef()));
        }
        if (this.nearbyDistanceMeterClass == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) enables nearby selection but lacks a nearbyDistanceMeterClass (%s).".formatted(this, this.nearbyDistanceMeterClass));
        }
        if (resolvedSelectionOrder != SelectionOrder.ORIGINAL && resolvedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) with originEntitySelector (%s), originSubListSelector (%s), originValueSelector (%s) and nearbyDistanceMeterClass (%s) has a resolvedSelectionOrder (%s) that is not %s or %s.\nMaybe remove difficultyComparatorClass or difficultyWeightFactoryClass from your @%s annotation.\nMaybe remove strengthComparatorClass or strengthWeightFactoryClass from your @%s annotation.\nMaybe disable nearby selection.".formatted(new Object[]{this, this.originEntitySelectorConfig, this.originSubListSelectorConfig, this.originValueSelectorConfig, this.nearbyDistanceMeterClass, resolvedSelectionOrder, SelectionOrder.ORIGINAL, SelectionOrder.RANDOM, PlanningEntity.class.getSimpleName(), PlanningVariable.class.getSimpleName()}));
        }
        if (resolvedCacheType.isCached()) {
            throw new IllegalArgumentException("The nearbySelectorConfig (%s) with originEntitySelector (%s), originSubListSelector (%s), originValueSelector (%s) and nearbyDistanceMeterClass (%s) has a resolvedCacheType (%s) that is cached.".formatted(new Object[]{this, this.originEntitySelectorConfig, this.originSubListSelectorConfig, this.originValueSelectorConfig, this.nearbyDistanceMeterClass, resolvedCacheType}));
        }
    }

    @Override
    public @NonNull NearbySelectionConfig inherit(@NonNull NearbySelectionConfig inheritedConfig) {
        this.originEntitySelectorConfig = ConfigUtils.inheritConfig(this.originEntitySelectorConfig, inheritedConfig.getOriginEntitySelectorConfig());
        this.originSubListSelectorConfig = ConfigUtils.inheritConfig(this.originSubListSelectorConfig, inheritedConfig.getOriginSubListSelectorConfig());
        this.originValueSelectorConfig = ConfigUtils.inheritConfig(this.originValueSelectorConfig, inheritedConfig.getOriginValueSelectorConfig());
        this.nearbyDistanceMeterClass = ConfigUtils.inheritOverwritableProperty(this.nearbyDistanceMeterClass, inheritedConfig.getNearbyDistanceMeterClass());
        this.nearbySelectionDistributionType = ConfigUtils.inheritOverwritableProperty(this.nearbySelectionDistributionType, inheritedConfig.getNearbySelectionDistributionType());
        this.blockDistributionSizeMinimum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMinimum, inheritedConfig.getBlockDistributionSizeMinimum());
        this.blockDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMaximum, inheritedConfig.getBlockDistributionSizeMaximum());
        this.blockDistributionSizeRatio = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeRatio, inheritedConfig.getBlockDistributionSizeRatio());
        this.blockDistributionUniformDistributionProbability = ConfigUtils.inheritOverwritableProperty(this.blockDistributionUniformDistributionProbability, inheritedConfig.getBlockDistributionUniformDistributionProbability());
        this.linearDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.linearDistributionSizeMaximum, inheritedConfig.getLinearDistributionSizeMaximum());
        this.parabolicDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.parabolicDistributionSizeMaximum, inheritedConfig.getParabolicDistributionSizeMaximum());
        this.betaDistributionAlpha = ConfigUtils.inheritOverwritableProperty(this.betaDistributionAlpha, inheritedConfig.getBetaDistributionAlpha());
        this.betaDistributionBeta = ConfigUtils.inheritOverwritableProperty(this.betaDistributionBeta, inheritedConfig.getBetaDistributionBeta());
        return this;
    }

    @Override
    public @NonNull NearbySelectionConfig copyConfig() {
        return new NearbySelectionConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        if (this.originEntitySelectorConfig != null) {
            this.originEntitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.originSubListSelectorConfig != null) {
            this.originSubListSelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.originValueSelectorConfig != null) {
            this.originValueSelectorConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.nearbyDistanceMeterClass);
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return true;
    }
}

