/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.api.solver.SolverStatus;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SolverManager<Solution_, ProblemId_>
extends AutoCloseable {
    public static <Solution_, ProblemId_> @NonNull SolverManager<Solution_, ProblemId_> create(@NonNull SolverConfig solverConfig) {
        return SolverManager.create(solverConfig, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> @NonNull SolverManager<Solution_, ProblemId_> create(@NonNull SolverConfig solverConfig, @NonNull SolverManagerConfig solverManagerConfig) {
        return SolverManager.create(SolverFactory.create(solverConfig), solverManagerConfig);
    }

    public static <Solution_, ProblemId_> @NonNull SolverManager<Solution_, ProblemId_> create(@NonNull SolverFactory<Solution_> solverFactory) {
        return SolverManager.create(solverFactory, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> @NonNull SolverManager<Solution_, ProblemId_> create(@NonNull SolverFactory<Solution_> solverFactory, @NonNull SolverManagerConfig solverManagerConfig) {
        return new DefaultSolverManager(solverFactory, solverManagerConfig);
    }

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> solveBuilder();

    default public @NonNull SolverJob<Solution_, ProblemId_> solve(@NonNull ProblemId_ problemId, @NonNull Solution_ problem) {
        return this.solveBuilder().withProblemId(problemId).withProblem(problem).run();
    }

    default public @NonNull SolverJob<Solution_, ProblemId_> solve(@NonNull ProblemId_ problemId, @NonNull Solution_ problem, @Nullable Consumer<? super Solution_> finalBestSolutionConsumer) {
        SolverJobBuilder<? super Solution_, ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblem(problem);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solve(@NonNull ProblemId_ problemId, @NonNull Solution_ problem, @Nullable Consumer<? super Solution_> finalBestSolutionConsumer, @Nullable BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblem(problem);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solve(@NonNull ProblemId_ problemId, @NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder, @Nullable Consumer<? super Solution_> finalBestSolutionConsumer) {
        SolverJobBuilder<? super Solution_, ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solve(@NonNull ProblemId_ problemId, @NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder, @Nullable Consumer<? super Solution_> finalBestSolutionConsumer, @Nullable BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solveAndListen(@NonNull ProblemId_ problemId, @NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder, @NonNull Consumer<? super Solution_> bestSolutionConsumer) {
        return this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder).withBestSolutionConsumer(bestSolutionConsumer).run();
    }

    default public @NonNull SolverJob<Solution_, ProblemId_> solveAndListen(@NonNull ProblemId_ problemId, @NonNull Solution_ problem, @NonNull Consumer<? super Solution_> bestSolutionConsumer) {
        return this.solveBuilder().withProblemId(problemId).withProblem(problem).withBestSolutionConsumer(bestSolutionConsumer).run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solveAndListen(@NonNull ProblemId_ problemId, @NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder, @NonNull Consumer<? super Solution_> bestSolutionConsumer, @Nullable BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder).withBestSolutionConsumer(bestSolutionConsumer);
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public @NonNull SolverJob<Solution_, ProblemId_> solveAndListen(@NonNull ProblemId_ problemId, @NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder, @NonNull Consumer<? super Solution_> bestSolutionConsumer, @Nullable Consumer<? super Solution_> finalBestSolutionConsumer, @Nullable BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder).withBestSolutionConsumer(bestSolutionConsumer);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    public @NonNull SolverStatus getSolverStatus(@NonNull ProblemId_ var1);

    default public @NonNull CompletableFuture<Void> addProblemChange(@NonNull ProblemId_ problemId, @NonNull ProblemChange<Solution_> problemChange) {
        return this.addProblemChanges(problemId, Collections.singletonList(problemChange));
    }

    public @NonNull CompletableFuture<Void> addProblemChanges(@NonNull ProblemId_ var1, @NonNull List<ProblemChange<Solution_>> var2);

    public void terminateEarly(@NonNull ProblemId_ var1);

    @Override
    public void close();
}

