/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.api.solver.SolverJob;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

public interface SolverJobBuilder<Solution_, ProblemId_> {
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withProblemId(@NonNull ProblemId_ var1);

    default public @NonNull SolverJobBuilder<Solution_, ProblemId_> withProblem(@NonNull Solution_ problem) {
        return this.withProblemFinder(id -> problem);
    }

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withProblemFinder(@NonNull Function<? super ProblemId_, ? extends Solution_> var1);

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withBestSolutionConsumer(@NonNull Consumer<? super Solution_> var1);

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withFinalBestSolutionConsumer(@NonNull Consumer<? super Solution_> var1);

    @Deprecated(forRemoval=true, since="1.19.0")
    default public @NonNull SolverJobBuilder<Solution_, ProblemId_> withFirstInitializedSolutionConsumer(@NonNull Consumer<? super Solution_> firstInitializedSolutionConsumer) {
        return this.withFirstInitializedSolutionConsumer((? super Solution_ solution, boolean isTerminatedEarly) -> firstInitializedSolutionConsumer.accept((Object)solution));
    }

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withFirstInitializedSolutionConsumer(@NonNull FirstInitializedSolutionConsumer<? super Solution_> var1);

    public SolverJobBuilder<Solution_, ProblemId_> withSolverJobStartedConsumer(Consumer<? super Solution_> var1);

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withExceptionHandler(@NonNull BiConsumer<? super ProblemId_, ? super Throwable> var1);

    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withConfigOverride(@NonNull SolverConfigOverride<Solution_> var1);

    public @NonNull SolverJob<Solution_, ProblemId_> run();

    @NullMarked
    public static interface FirstInitializedSolutionConsumer<Solution_> {
        public void accept(Solution_ var1, boolean var2);
    }
}

