/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintStream;
import ai.timefold.solver.core.api.score.stream.bi.BiJoiner;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintStream;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public interface UniConstraintStream<A>
extends ConstraintStream {
    public @NonNull UniConstraintStream<A> filter(@NonNull Predicate<A> var1);

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> otherStream) {
        return this.join(otherStream, new BiJoiner[0]);
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner) {
        return this.join(otherStream, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull BiConstraintStream<A, B> join(@NonNull UniConstraintStream<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass) {
        return this.join(otherClass, new BiJoiner[0]);
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner) {
        return this.join(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner) {
        return this.ifExists(otherStream, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifExists(otherStream, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifExists(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifExists(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull UniConstraintStream<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> var1, BiJoiner<A, B> ... var2);

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass) {
        return this.ifExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering(ConstantLambdaUtils.notEquals()));
    }

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3, @NonNull BiJoiner<A, A> joiner4) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOther(@NonNull Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner otherness = Joiners.filtering(ConstantLambdaUtils.notEquals());
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifExists(otherClass, allJoiners);
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[0]);
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3, @NonNull BiJoiner<A, A> joiner4) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public @NonNull UniConstraintStream<A> ifExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner otherness = Joiners.filtering(ConstantLambdaUtils.notEquals());
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifExistsIncludingUnassigned(otherClass, allJoiners);
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner) {
        return this.ifNotExists(otherStream, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifNotExists(otherStream, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifNotExists(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull UniConstraintStream<B> otherStream, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifNotExists(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull UniConstraintStream<B> var1, BiJoiner<A, B> ... var2);

    default public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> otherClass, @NonNull BiJoiner<A, B> joiner1, @NonNull BiJoiner<A, B> joiner2, @NonNull BiJoiner<A, B> joiner3, @NonNull BiJoiner<A, B> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> var1, BiJoiner<A, B> ... var2);

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass) {
        return this.ifNotExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering(ConstantLambdaUtils.notEquals()));
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3, @NonNull BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOther(@NonNull Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner otherness = Joiners.filtering(ConstantLambdaUtils.notEquals());
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifNotExists(otherClass, allJoiners);
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[0]);
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, @NonNull BiJoiner<A, A> joiner1, @NonNull BiJoiner<A, A> joiner2, @NonNull BiJoiner<A, A> joiner3, @NonNull BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public @NonNull UniConstraintStream<A> ifNotExistsOtherIncludingUnassigned(@NonNull Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner otherness = Joiners.filtering(ConstantLambdaUtils.notEquals());
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifNotExistsIncludingUnassigned(otherClass, allJoiners);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[0]);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        return this.ifNotExistsOtherIncludingUnassigned(otherClass, joiners);
    }

    public <ResultContainer_, Result_> @NonNull UniConstraintStream<Result_> groupBy(@NonNull UniConstraintCollector<A, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> @NonNull BiConstraintStream<ResultA_, ResultB_> groupBy(@NonNull UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, @NonNull UniConstraintCollector<A, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> @NonNull TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(@NonNull UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, @NonNull UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, @NonNull UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(@NonNull UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, @NonNull UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, @NonNull UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, @NonNull UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> @NonNull UniConstraintStream<GroupKey_> groupBy(@NonNull Function<A, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> @NonNull BiConstraintStream<GroupKey_, Result_> groupBy(@NonNull Function<A, GroupKey_> var1, @NonNull UniConstraintCollector<A, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> @NonNull TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(@NonNull Function<A, GroupKey_> var1, @NonNull UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, @NonNull UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(@NonNull Function<A, GroupKey_> var1, @NonNull UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, @NonNull UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, @NonNull UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> @NonNull BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> @NonNull TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2, @NonNull UniConstraintCollector<A, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2, @NonNull UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, @NonNull UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> @NonNull TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2, @NonNull Function<A, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2, @NonNull Function<A, GroupKeyC_> var3, @NonNull UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(@NonNull Function<A, GroupKeyA_> var1, @NonNull Function<A, GroupKeyB_> var2, @NonNull Function<A, GroupKeyC_> var3, @NonNull Function<A, GroupKeyD_> var4);

    public <ResultA_> @NonNull UniConstraintStream<ResultA_> map(@NonNull Function<A, ResultA_> var1);

    public <ResultA_, ResultB_> @NonNull BiConstraintStream<ResultA_, ResultB_> map(@NonNull Function<A, ResultA_> var1, @NonNull Function<A, ResultB_> var2);

    public <ResultA_, ResultB_, ResultC_> @NonNull TriConstraintStream<ResultA_, ResultB_, ResultC_> map(@NonNull Function<A, ResultA_> var1, @NonNull Function<A, ResultB_> var2, @NonNull Function<A, ResultC_> var3);

    public <ResultA_, ResultB_, ResultC_, ResultD_> @NonNull QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> map(@NonNull Function<A, ResultA_> var1, @NonNull Function<A, ResultB_> var2, @NonNull Function<A, ResultC_> var3, @NonNull Function<A, ResultD_> var4);

    public <ResultA_> @NonNull UniConstraintStream<ResultA_> flattenLast(@NonNull Function<A, Iterable<ResultA_>> var1);

    public @NonNull UniConstraintStream<A> distinct();

    public @NonNull UniConstraintStream<A> concat(@NonNull UniConstraintStream<A> var1);

    default public <B> @NonNull BiConstraintStream<A, B> concat(@NonNull BiConstraintStream<A, B> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.uniConstantNull());
    }

    public <B> @NonNull BiConstraintStream<A, B> concat(@NonNull BiConstraintStream<A, B> var1, @NonNull Function<A, B> var2);

    default public <B, C> @NonNull TriConstraintStream<A, B, C> concat(@NonNull TriConstraintStream<A, B, C> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.uniConstantNull(), ConstantLambdaUtils.uniConstantNull());
    }

    public <B, C> @NonNull TriConstraintStream<A, B, C> concat(@NonNull TriConstraintStream<A, B, C> var1, @NonNull Function<A, B> var2, @NonNull Function<A, C> var3);

    default public <B, C, D> @NonNull QuadConstraintStream<A, B, C, D> concat(@NonNull QuadConstraintStream<A, B, C, D> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.uniConstantNull(), ConstantLambdaUtils.uniConstantNull(), ConstantLambdaUtils.uniConstantNull());
    }

    public <B, C, D> @NonNull QuadConstraintStream<A, B, C, D> concat(@NonNull QuadConstraintStream<A, B, C, D> var1, @NonNull Function<A, B> var2, @NonNull Function<A, C> var3, @NonNull Function<A, D> var4);

    public <ResultB_> @NonNull BiConstraintStream<A, ResultB_> expand(@NonNull Function<A, ResultB_> var1);

    public <ResultB_, ResultC_> @NonNull TriConstraintStream<A, ResultB_, ResultC_> expand(@NonNull Function<A, ResultB_> var1, @NonNull Function<A, ResultC_> var2);

    public <ResultB_, ResultC_, ResultD_> @NonNull QuadConstraintStream<A, ResultB_, ResultC_, ResultD_> expand(@NonNull Function<A, ResultB_> var1, @NonNull Function<A, ResultC_> var2, @NonNull Function<A, ResultD_> var3);

    default public @NonNull UniConstraintStream<A> complement(@NonNull Class<A> otherClass) {
        UniConstraintStream firstStream = this;
        UniConstraintStream<A> secondStream = this.getConstraintFactory().forEach(otherClass).ifNotExists((UniConstraintStream<B>)firstStream, (BiJoiner<A, B>)Joiners.equal());
        return firstStream.concat(secondStream);
    }

    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalize(@NonNull Score_ constraintWeight) {
        return this.penalize(constraintWeight, ConstantLambdaUtils.uniConstantOne());
    }

    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeLong(@NonNull Score_ constraintWeight) {
        return this.penalizeLong(constraintWeight, ConstantLambdaUtils.uniConstantOneLong());
    }

    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeBigDecimal(@NonNull Score_ constraintWeight) {
        return this.penalizeBigDecimal(constraintWeight, ConstantLambdaUtils.uniConstantOneBigDecimal());
    }

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalize(@NonNull Score_ var1, @NonNull ToIntFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeLong(@NonNull Score_ var1, @NonNull ToLongFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeBigDecimal(@NonNull Score_ var1, @NonNull Function<A, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public UniConstraintBuilder<A, ?> penalizeConfigurable() {
        return this.penalizeConfigurable(ConstantLambdaUtils.uniConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> penalizeConfigurable(ToIntFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> penalizeConfigurableLong(ToLongFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> penalizeConfigurableBigDecimal(Function<A, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> reward(@NonNull Score_ constraintWeight) {
        return this.reward(constraintWeight, ConstantLambdaUtils.uniConstantOne());
    }

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> reward(@NonNull Score_ var1, @NonNull ToIntFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> rewardLong(@NonNull Score_ var1, @NonNull ToLongFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> rewardBigDecimal(@NonNull Score_ var1, @NonNull Function<A, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public UniConstraintBuilder<A, ?> rewardConfigurable() {
        return this.rewardConfigurable(ConstantLambdaUtils.uniConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> rewardConfigurable(ToIntFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> rewardConfigurableLong(ToLongFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> rewardConfigurableBigDecimal(Function<A, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impact(@NonNull Score_ constraintWeight) {
        return this.impact(constraintWeight, ConstantLambdaUtils.uniConstantOne());
    }

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impact(@NonNull Score_ var1, @NonNull ToIntFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impactLong(@NonNull Score_ var1, @NonNull ToLongFunction<A> var2);

    public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impactBigDecimal(@NonNull Score_ var1, @NonNull Function<A, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public UniConstraintBuilder<A, ?> impactConfigurable() {
        return this.impactConfigurable(ConstantLambdaUtils.uniConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> impactConfigurable(ToIntFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> impactConfigurableLong(ToLongFunction<A> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public UniConstraintBuilder<A, ?> impactConfigurableBigDecimal(Function<A, BigDecimal> var1);

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        return this.ifExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[0]);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        return this.ifExistsOtherIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        return this.ifNotExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    default public Constraint impactConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }
}

