/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DefaultConstraintJustification
implements ConstraintJustification,
Comparable<DefaultConstraintJustification> {
    private final Score<?> impact;
    private final List<Object> facts;

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, Object fact) {
        return DefaultConstraintJustification.of(impact, Collections.singletonList(fact));
    }

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB) {
        return DefaultConstraintJustification.of(impact, Arrays.asList(factA, factB));
    }

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB, Object factC) {
        return DefaultConstraintJustification.of(impact, Arrays.asList(factA, factB, factC));
    }

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB, Object factC, Object factD) {
        return DefaultConstraintJustification.of(impact, Arrays.asList(factA, factB, factC, factD));
    }

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, Object ... facts) {
        return DefaultConstraintJustification.of(impact, Arrays.asList(facts));
    }

    public static @NonNull DefaultConstraintJustification of(Score<?> impact, List<Object> facts) {
        return new DefaultConstraintJustification(impact, facts);
    }

    private DefaultConstraintJustification(Score<?> impact, List<Object> facts) {
        this.impact = impact;
        this.facts = facts;
    }

    public <Score_ extends Score<Score_>> Score_ getImpact() {
        return (Score_)this.impact;
    }

    public @NonNull List<@Nullable Object> getFacts() {
        return this.facts;
    }

    public String toString() {
        return this.facts.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultConstraintJustification) {
            DefaultConstraintJustification other = (DefaultConstraintJustification)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.facts.hashCode();
    }

    @Override
    public int compareTo(DefaultConstraintJustification other) {
        List<Object> otherJustificationList;
        List<Object> justificationList = this.getFacts();
        if (justificationList != (otherJustificationList = other.getFacts())) {
            if (justificationList.size() != otherJustificationList.size()) {
                return Integer.compare(justificationList.size(), otherJustificationList.size());
            }
            for (int i = 0; i < justificationList.size(); ++i) {
                Object right;
                Object left = justificationList.get(i);
                int comparison = DefaultConstraintJustification.compareElements(left, right = otherJustificationList.get(i));
                if (comparison == 0) continue;
                return comparison;
            }
        }
        return 0;
    }

    private static int compareElements(Object left, Object right) {
        Class<?> rightClass;
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        Class<?> leftClass = left.getClass();
        if (leftClass != (rightClass = right.getClass())) {
            return leftClass.getCanonicalName().compareTo(rightClass.getCanonicalName());
        }
        if (left instanceof Comparable) {
            Comparable comparable = (Comparable)left;
            return comparable.compareTo(right);
        }
        if (Objects.equals(left, right)) {
            return 0;
        }
        return Integer.compare(left.hashCode(), right.hashCode());
    }
}

