/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simplebigdecimal;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleBigDecimalScore
implements Score<SimpleBigDecimalScore> {
    public static final SimpleBigDecimalScore ZERO = new SimpleBigDecimalScore(BigDecimal.ZERO);
    public static final SimpleBigDecimalScore ONE = new SimpleBigDecimalScore(BigDecimal.ONE);
    private final BigDecimal score;

    public static SimpleBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleBigDecimalScore.class, scoreString, "");
        BigDecimal score = ScoreUtil.parseLevelAsBigDecimal(SimpleBigDecimalScore.class, scoreString, scoreTokens[0]);
        return SimpleBigDecimalScore.of(score);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static SimpleBigDecimalScore ofUninitialized(int initScore, BigDecimal score) {
        return SimpleBigDecimalScore.of(score);
    }

    public static SimpleBigDecimalScore of(BigDecimal score) {
        if (score.signum() == 0) {
            return ZERO;
        }
        if (score.equals(BigDecimal.ONE)) {
            return ONE;
        }
        return new SimpleBigDecimalScore(score);
    }

    private SimpleBigDecimalScore() {
        this(BigDecimal.ZERO);
    }

    private SimpleBigDecimalScore(BigDecimal score) {
        this.score = score;
    }

    public BigDecimal score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getScore() {
        return this.score;
    }

    @Override
    public SimpleBigDecimalScore add(SimpleBigDecimalScore addend) {
        return SimpleBigDecimalScore.of(this.score.add(addend.score()));
    }

    @Override
    public SimpleBigDecimalScore subtract(SimpleBigDecimalScore subtrahend) {
        return SimpleBigDecimalScore.of(this.score.subtract(subtrahend.score()));
    }

    @Override
    public SimpleBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return SimpleBigDecimalScore.of(this.score.multiply(multiplicandBigDecimal).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return SimpleBigDecimalScore.of(this.score.divide(divisorBigDecimal, this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return SimpleBigDecimalScore.of(this.score.pow(exponentBigDecimal.intValue()).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore abs() {
        return SimpleBigDecimalScore.of(this.score.abs());
    }

    @Override
    public SimpleBigDecimalScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return true;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleBigDecimalScore) {
            SimpleBigDecimalScore other = (SimpleBigDecimalScore)o;
            return this.score.stripTrailingZeros().equals(other.score().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return this.score.stripTrailingZeros().hashCode();
    }

    @Override
    public int compareTo(SimpleBigDecimalScore other) {
        return this.score.compareTo(other.score());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "");
    }

    public String toString() {
        return this.score.toString();
    }
}

