package com.xebialabs.deployit.core.util

import com.xebialabs.xlplatform.utils.SecureRandomHolder
import org.apache.commons.codec.binary.Hex
import org.apache.commons.codec.digest.DigestUtils

object TokenGenerator {

  private val DEFAULT_TOKEN_LENGTH = 20

  def generate(prefix: String): String = {
    val randomBytes = SecureRandomHolder.getRandomByteArray(DEFAULT_TOKEN_LENGTH)
    val token = Hex.encodeHexString(randomBytes)
    s"$prefix$token"
  }

  def hash(token: String): String = {
    val tokenHash = DigestUtils.sha384Hex(token)
    s"{SHA-384}$tokenHash"
  }
}