package com.xebialabs.deployit.core.util

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.jdk.CollectionConverters._
import java.util

object CiUtils {
  def getIdWithoutRoot(id: String): String = {
    val split = id.split("/", 2)
    if (split.length == 1) id
    else split(1)
  }

  def getName(id: String): String = id.substring(id.lastIndexOf('/') + 1)

  def toCiIds(cis: util.Collection[ConfigurationItem]): util.List[ConfigurationItemId] =
    cis.asScala.map(ci => new ConfigurationItemId(ci.getId, ci.getType)).toList.asJava
}
