package com.xebialabs.deployit.core.util

import org.joda.time.DateTime

import java.lang.{Boolean => JBoolean}
import java.math.BigDecimal
import java.sql.Timestamp
import java.util.Date

object TypeConversions {
  def enforceBoolean(any: Any): JBoolean = {
    if (any == null) {
      return null
    }
    any match {
      case i: Number => i.intValue() != 0
      case a => a.asInstanceOf[JBoolean]
    }
  }

  def enforceInteger(any: Any): Integer = {
    if (any == null) {
      return null
    }
    any match {
      case b: BigDecimal => b.intValue()
      case a => a.asInstanceOf[java.lang.Integer]
    }
  }

  def enforceDate(any: Any): Date = {
    if (any == null) {
      return null
    }
    any match {
      case t: Timestamp => new Date(t.getTime)
      case jd: DateTime => jd.toLocalDateTime.toDate
      case a => a.asInstanceOf[Date]
    }
  }
}
