package com.xebialabs.deployit.core.util

import scala.language.implicitConversions

object IdExtensions {
  class IdString(id: String) {
    def getName: String = {
      Option(id).getOrElse("").lastIndexOf('/') match {
        case lastSlashPos if lastSlashPos > -1 => id.substring(lastSlashPos + 1)
        case _ => id
      }
    }

    def getParent: String = {
      Option(id).getOrElse("").lastIndexOf('/') match {
        case lastSlashPos if lastSlashPos > 0 => id.substring(0, lastSlashPos)
        case _ => ""
      }
    }

    def getRoot: String = Option(id).map(_.split('/').head).orNull
  }

  implicit def idString(id: String): IdString = new IdString(id)
}
