package com.xebialabs.deployit.core.util

import com.xebialabs.deployit.checks.Checks

object CiValidationUtils {
  final val illegalIdCharacters = Set('*', '[', ']', ':', '\\', '|')
  final val illegalNameCharacters = illegalIdCharacters + '/'

  def validateName(name: String): Unit =
    Checks.checkArgument(!name.exists(illegalNameCharacters.contains), "'%s' is not a valid name.", name)

  private def noTrailingAndLeadingSpace(id: String) = !id.matches(".*/[\\s].*|.*[\\s]$|^[\\s].*|.*[\\s]/.*")

  def validateId(id: String): Unit = {
    val hasNoInvalidCharacters = !id.exists(illegalIdCharacters.contains)
    Checks.checkArgument(
      !id.contains("//") && hasNoInvalidCharacters && noTrailingAndLeadingSpace(id), "'%s' is not a valid path.", id
    )
  }
}
