/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.util;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static Set<ConfigurationItem> resolve(Set<Integer> values, Function<? super Integer, ? extends ConfigurationItem> resolver) {
        return values.stream().map(resolver).collect(Collectors.toSet());
    }

    public static List<ConfigurationItem> resolve(List<Integer> values, Function<? super Integer, ? extends ConfigurationItem> resolver) {
        return values.stream().map(resolver).collect(Collectors.toList());
    }

    public static Map<String, String> toMap(List<Map<String, Object>> results, String key, String value) {
        return results.stream().collect(Collectors.toMap(map -> (String)map.get(key), map -> (String)map.get(value)));
    }

    public static <S, T> Set<T> apply(Set<S> values, Function<? super S, T> func) {
        return values.stream().map(func).collect(Collectors.toSet());
    }

    public static <S, T> List<T> apply(List<S> values, Function<? super S, T> func) {
        return values.stream().map(func).collect(Collectors.toList());
    }

    public static <S, T> Map<String, T> apply(Map<String, S> values, Function<? super S, T> func) {
        return values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> func.apply((Object)entry.getValue())));
    }
}

