package com.xebialabs.deployit.core.util

import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, DescriptorRegistry, Type}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.reflect.ClassTag

object CiSugar {

  implicit class IdOps(id: String) {
    lazy val pathElements: Array[String] = id.split("/").filter(_.nonEmpty)
    lazy val allPaths: Vector[String] = {
      val (_, accumulated) = pathElements.foldLeft(("", Vector[String]())) { case ((currentPath, acc), element) =>
        val newPath = s"$currentPath/$element"
        (newPath, acc :+ newPath)
      }
      accumulated
    }
  }

  implicit class CiTypeNameOps(name: String) {
    lazy val ciType: Type = Type.valueOf(name)
  }

  implicit class TypeOps(`type`: Type) {
    lazy val descriptor: Descriptor = DescriptorRegistry.getDescriptor(`type`)
  }

  implicit class ClassOps(clazz: Class[_]) {
    lazy val ciType: Type = Type.valueOf(clazz)
  }

  implicit class ConfigurationItemOps(configurationItem: ConfigurationItem) {
    def instanceOf[T <: ConfigurationItem : ClassTag]: Boolean =
      configurationItem.getType.instanceOf(implicitly[ClassTag[T]].runtimeClass.ciType)
  }
}
