package com.xebialabs.deployit.core.serializers

import com.fasterxml.jackson.annotation.ObjectIdGenerator
import com.fasterxml.jackson.annotation.ObjectIdGenerator.IdKey
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

object ConfigurationItemObjectIdGenerator extends ObjectIdGenerator[String] {
  override def canUseFor(gen: ObjectIdGenerator[_]): Boolean =
    gen == this

  override def generateId(forPojo: scala.Any): String =
    forPojo match {
      case ci: ConfigurationItem => ci.getId
      case v => throw new IllegalStateException("Cannot create ObjectId: no ConfigurationItem: " + v)
    }

  override def key(key: scala.Any): ObjectIdGenerator.IdKey = new IdKey(this.getClass, null, key)

  override def newForSerialization(context: scala.Any): ObjectIdGenerator[String] = this

  override def getScope: Class[_] = null

  override def forScope(scope: Class[_]): ObjectIdGenerator[String] = this
}
