package com.xebialabs.deployit.core

import com.xebialabs.deployit.core.util.CollectionUtil
import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, Type}
import com.xebialabs.deployit.repository.StringValueConverter._
import com.xebialabs.deployit.util.PasswordEncrypter

import java.util

package object serializers {

  def forAllNonTransientProperties(t: Type, filter: PropertyDescriptor => Boolean = !_.isTransient)(block: PropertyDescriptor => Unit): Unit = {
    import scala.jdk.FunctionConverters._
    t.getDescriptor.getPropertyDescriptors.stream.filter(filter.asJava).forEach(block(_))
  }

  private[serializers] def convertList(value: util.List[String], encrypt: Boolean, passwordEncrypter: PasswordEncrypter): ListOfStringView = {
    val listResult = new ListOfStringView(CollectionUtil.apply[String, StringValue](value, stringToValue(passwordEncrypter)))
    if (encrypt)
      listResult.encrypt
    else
      listResult
  }

  private[serializers] def convertSet(value: util.Set[String], encrypt: Boolean, passwordEncrypter: PasswordEncrypter): SetOfStringView = {
    val setResult = new SetOfStringView(CollectionUtil.apply[String, StringValue](value, stringToValue(passwordEncrypter)))
    if (encrypt)
      setResult.encrypt
    else
      setResult
  }

  private[serializers] def convertMap(value: util.Map[String, String], encrypt: Boolean, passwordEncrypter: PasswordEncrypter): MapStringStringView = {
    val mapResult = new MapStringStringView(CollectionUtil.apply[String, StringValue](value, stringToValue(passwordEncrypter)))
    if (encrypt)
      mapResult.encrypt
    else
      mapResult
  }

}
