package com.xebialabs.deployit.core.serializers.mapper

import com.fasterxml.jackson.core.util.{DefaultIndenter, DefaultPrettyPrinter}
import com.fasterxml.jackson.databind.ObjectMapper

object JsonSerialization {
  private val prettyPrinter = {
    val defaultPrettyPrinter = new DefaultPrettyPrinter()
    defaultPrettyPrinter.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)
    defaultPrettyPrinter.indentObjectsWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)
    defaultPrettyPrinter
  }

  val mapper: ObjectMapper = new ObjectMapper().setDefaultPrettyPrinter(prettyPrinter)
}
