package ai.digital.deploy.core.notification.api

import com.xebialabs.deployit.core.events.ChangeSetEvent


/**
  * Service, created to notify other parties about the changes over events.
  */
trait EventNotificationService {
  /**
    * Sends a notification to JMS channel which is going to be picked.
    * Used to notify client (GUI) over the changes with a subsequent call via WebSockets.
    *
    * @param event set of changed CIs
    */
  def sendChangeSetEvent(event: ChangeSetEvent): Unit
}
