package com.xebialabs.deployit.core.events.dto

import org.joda.time.DateTime

case class DeployedApplicationPackage(operation: String,
                                      applicationName: String,
                                      applicationUid: String,
                                      applicationPath: String,
                                      versionTag: String,
                                      destination: String,
                                      destinationUid: String,
                                      destinationPath: String
                                     )

case class ApplicationDeploymentPackageState(applicationName: String,
                                             applicationUid: String,
                                             applicationPath: String,
                                             state: DeploymentPackageState)

case class DeploymentPackageState(destination: String,
                                  destinationUid: String,
                                  destinationPath: String,
                                  versionTag: String,
                                  deploymentStatus: String,
                                  deploymentType: String,
                                  user: String,
                                  lastChangeTime: DateTime)

object StateOperation {
  final val CreateState = "create"
  final val RemoveState = "remove"
}
