package com.xebialabs.deployit.core.events

import com.xebialabs.deployit.engine.api.dto.{ApplicationDeploymentPackage, DeployedApplicationPackage, VersionTag}
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState
import org.joda.time.DateTime


class DeploymentPackageEvent()
case class CreateApplicationDeploymentPackage(applicationDeploymentPackage: ApplicationDeploymentPackage) extends DeploymentPackageEvent
case class DeleteApplicationDeploymentPackage(applicationDeploymentPackage: ApplicationDeploymentPackage) extends DeploymentPackageEvent

case class ApplicationDeploymentPackageStateEvent(
                                                   applicationName: String,
                                                   applicationPath: String,
                                                   destination: String,
                                                   versionTag: VersionTag,
                                                   deploymentStatus: TaskExecutionState,
                                                   deploymentType: String,
                                                   user: String,
                                                   lastChangeTime: DateTime
                                                 )

class DeployedApplicationPackageEvent()
case class CreateDeployedApplicationPackage(deployedApplicationPackage: DeployedApplicationPackage) extends DeployedApplicationPackageEvent
case class DeleteDeployedApplicationPackage(deployedApplicationPackage: DeployedApplicationPackage) extends DeployedApplicationPackageEvent

