package com.xebialabs.deployit.resolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.UrlResource;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class XLPluginAwareResourcePatternResolver extends PathMatchingResourcePatternResolver implements ResourcePatternResolver {
    private static final Logger log = LoggerFactory.getLogger(XLPluginAwareResourcePatternResolver.class);

    @Override
    protected Resource convertClassLoaderURL(URL url) {
        if (url.getProtocol().equals("xlp")) {
            return new UrlResource(url){
                @Override
                public Resource createRelative(String relativePath) {
                    return new UrlResource(url);
                }
            };
        }
        else {
            return super.convertClassLoaderURL(url);
        }
    }

    @SuppressWarnings("NullableProblems")
    @Override
    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        URL resourceUrl = rootDirResource.getURL();
        if (resourceUrl.getProtocol().equals("xlp")) {
            log.debug("Skipping Spring component scan in XL Plugin: {}", resourceUrl);
            return new HashSet<>();
        } else {
            return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
        }
    }
}
