package com.xebialabs.deployit.hocon

import com.typesafe.config.Config
import com.xebialabs.deployit.security.SecretKeyHolder
import com.xebialabs.deployit.tasksystem.ConfigLoading
import com.xebialabs.xlplatform.config.ConfigLoader
import org.springframework.core.io.Resource

class ServerHoconConfigLoader extends HoconConfigLoader {

  override def loadConfig(resource: Resource): Config = {
    val resourceFilename = resource.getFilename
    val basicConfig: Config = loadBasicConfig(resource)

    val config = ConfigLoader.loadSecuredWithDynamic(
      configResource = resourceFilename,
      keyHolder = SecretKeyHolder.get(),
      defaultReference = ConfigLoading.loadConfig(basicConfig))
    ConfigLoading.loadConfig(config)
  }
}
