package com.xebialabs.deployit.core.config

import de.schlichtherle.truezip.file.TVFS
import de.schlichtherle.truezip.fs.FsSyncException
import grizzled.slf4j.Logging
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.stereotype.Component

@Configuration
class TrueZipShutdownConfiguration {
  @Bean(destroyMethod = "shutdown")
  def registerShutdownHook(): TrueZipShutdownHook = new TrueZipShutdownHook()
}

@Component
class TrueZipShutdownHook extends Logging {
  def shutdown(): Unit = {
    try {
      TVFS.umount()
      logger.info("TrueZIP filesystem synchronized before shutdown.")
    } catch {
      case e: FsSyncException =>
        logger.warn(s"Error during shutdown sync: ${e.getMessage}")
    }
  }
}
