package com.xebialabs.deployit.checksum

import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ChecksumAlgorithmConfiguration {

  @Value("${deploy.server.algorithms.checksum:SHA-256}")
  var checksum: String = _

  @Bean
  def checksumAlgorithmProviderFactory(): ChecksumAlgorithmProviderFactory = DefaultChecksumAlgorithmProviderFactory

  @Bean
  def checksumAlgorithmProvider(factory: ChecksumAlgorithmProviderFactory): ChecksumAlgorithmProvider = {
    factory.create(checksum)
  }
}
