package com.xebialabs.deployit.env;

import com.xebialabs.deployit.resolver.XLPluginAwareResourcePatternResolver;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;

import java.util.Set;

import static java.util.stream.Collectors.toSet;

public class SpringPoweredScanner {

    private final ClassPathScanningCandidateComponentProvider provider;

    public SpringPoweredScanner() {
        this.provider = new ClassPathScanningCandidateComponentProvider(false);
        this.provider.setResourceLoader(new XLPluginAwareResourcePatternResolver());
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        provider.addIncludeFilter(new AssignableTypeFilter(clazz));

        Set<Class<? extends T>> aiDigital = findSubClassesIn("ai/digital", clazz);
        Set<Class<? extends T>> comXebialabs = findSubClassesIn("com/xebialabs", clazz);
        Set<Class<? extends T>> extDeployit = findSubClassesIn("ext/deployit", clazz);

        aiDigital.addAll(comXebialabs);
        aiDigital.addAll(extDeployit);
        return aiDigital;
    }

    private <T> Set<Class<? extends T>> findSubClassesIn(String packageName, Class<T> subclass) {
        return provider.findCandidateComponents(packageName)
                .stream()
                .map(beanDefinition -> (Class<? extends T>) getClassAsSubclassOf(subclass, beanDefinition.getBeanClassName()))
                .collect(toSet());
    }

    private <T> Class<? extends T> getClassAsSubclassOf(Class<T> clazz, String className) {
        try {
            return Class.forName(className).asSubclass(clazz);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

}
