package com.xebialabs.deployit.hocon

import com.typesafe.config.{Config, ConfigFactory}
import org.springframework.core.io.Resource

trait HoconConfigLoader {

  def loadBasicConfig(resource: Resource): Config = {
    val resourceFilename = resource.getFilename
    ConfigFactory.parseResources(resourceFilename)
  }

  def loadConfig(resource: Resource): Config
}
