package com.xebialabs.deployit.booter.local

import ai.digital.config.server.api.{ConfigurationPropertiesService, PropertyValue}
import ai.digital.config.server.client.LocalConfigurationReader
import ai.digital.config.{ConfigFileFilter, ConfigFileMapping}
import org.springframework.stereotype.Component

import java.io.File
import scala.jdk.CollectionConverters._

@Component
class CentralConfigurationGlobalContextManager(val configFileFilter: ConfigFileFilter,
                                               val localConfigurationReader: LocalConfigurationReader,
                                               val configurationPropertiesService: ConfigurationPropertiesService)
  extends AbstractGlobalContextManager {

  override def loadStoredDefaults(configFile: File): Unit = {
    val properties = localConfigurationReader.readPropertySource(configFile.getName)
    addContextEntries(properties.asJava)
  }

  override def storeDefaults(configFile: File): Unit =
    if (configFile != null) {

      val properties = getContextEntries.iterator().asScala
        .map(pair => pair.key -> PropertyValue(pair.value.getValue, toComment(pair.value), !pair.value.isExplicit))
        .toSeq

      configurationPropertiesService.propertiesStore(
        configFileFilter,
        header(),
        properties,
        ConfigFileMapping(configFile.getName)
      )
    }
}

