package com.xebialabs.deployit.core.metrics

import com.zaxxer.hikari.metrics.{IMetricsTracker, MetricsTrackerFactory, PoolStats}
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import java.util.{Timer, TimerTask}

@Component
class XldDbMetricsTrackerFactory extends MetricsTrackerFactory {

  override def create(poolName: String, poolStats: PoolStats): IMetricsTracker = new IMetricsTracker with Logging {

    override def recordConnectionCreatedMillis(connectionCreatedMillis: Long): Unit = {
      // to refresh the pool stats , added delay of 1.1 second
      new Timer().schedule(new TimerTask() {
        override def run(): Unit = {
          if (poolStats.getTotalConnections == 0) {
            logger.info(s"$poolName - Trying to established a new database connection")
          } else {
            logger.info(s"$poolName - A new database connection is established")
          }
        }
      }, 1100)
    }
  }
}
