package com.xebialabs.deployit.env

import com.xebialabs.deployit.{ServerConfiguration, ServerLaunchOptions}

object ServerActiveProfileRegistry extends DynamicActiveProfileRegistry {

  def allActiveProfiles(launchOptions: ServerLaunchOptions,
                        serverConfig: ServerConfiguration): Array[String] =
    allDynamicActiveProfiles(launchOptions, serverConfig) ++ allDefaultProfiles()

  def allDynamicActiveProfiles(launchOptions: ServerLaunchOptions,
                               serverConfig: ServerConfiguration): Array[String] = {
    if(Option(Refs.get()).forall(_.isEmpty)) {
      init()
    }
    Refs.get().filter(
      p => !(Option(serverConfig).isDefined && (p.configPropertyCallback(serverConfig) || p.launchOptionsCallback(launchOptions))))
      .flatMap(_.profileNames)
  }

  override def allDefaultProfiles(): Array[String] = ServerActiveProfiles.values.map(_.toString).toArray

  def getActiveProfiles(launchOptions: ServerLaunchOptions,
                        serverConfig: ServerConfiguration): String =
    allActiveProfiles(launchOptions, serverConfig).mkString(",")
}
