package com.xebialabs.deployit.core.config.hash

import java.io.File

import com.xebialabs.deployit.repository.ConfigurationVersionRepository
import grizzled.slf4j.Logging

case class DatabaseConfigurationHashProvider(configurationVersionRepository: ConfigurationVersionRepository)
                                            (files: Seq[File])
  extends DefaultConfigurationHashProvider(files) with Logging {

  def init(): Unit = {
    info(s"Started with configuration hash: [$configurationHash]")
    configurationVersionRepository.save(configurationHash)
  }

}
