package com.xebialabs.deployit.env

import ai.digital.config.CentralConfigurationActiveProfiles
import com.xebialabs.deployit.ServerConfiguration
import grizzled.slf4j.Logging

object TaskEngineActiveProfileRegistry extends DynamicActiveProfileRegistry with Logging {

  val blacklistProfiles: Array[String] = new CentralConfigurationActiveProfiles().profileNames

  def allActiveProfiles(serverConfig: ServerConfiguration): Array[String] =
    allDynamicActiveProfiles(serverConfig) ++ allDefaultProfiles()

  def allDynamicActiveProfiles(serverConfig: ServerConfiguration): Array[String] = {
    if (Option(Refs.get()).forall(_.isEmpty)) {
      debug("Trying to initialize dynamic profiles")
      init()
      debug("Initialized dynamic profiles")
    }
    val profiles = Refs.get().filter(
      p => !(Option(serverConfig).isDefined && p.configPropertyCallback(serverConfig)))
      .flatMap(_.profileNames).filter(p => !blacklistProfiles.contains(p))
    debug(s"Dynamic profiles ${profiles.mkString(",")}")
    profiles
  }

  override def allDefaultProfiles(): Array[String] = TaskEngineActiveProfiles.values.map(_.toString).toArray


  def getActiveProfiles(serverConfig: ServerConfiguration): String =
    allActiveProfiles(serverConfig).mkString(",")
}
