package com.xebialabs.deployit.configuration.system

import ai.digital.config.ConfigClientSystemValues
import ai.digital.config.server.embedded.EmbeddedConfigServerSystemValues
import com.xebialabs.deployit.ServerConfiguration

object SystemValues extends EmbeddedConfigServerSystemValues with ConfigClientSystemValues {

  def apply(): SystemValues.type = {
    System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "com.xebialabs.deployit.util.CustomForkJoinWorkerThreadFactory")
    System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager")
    System.setProperty("liquibase.hub.mode", "off")
    this
  }

  def apply(profiles: String): SystemValues.type = {
    System.setProperty("spring.profiles.active", profiles)
    this
  }

  def apply(serverConfiguration: ServerConfiguration): SystemValues.type = {
    applyConfigClientRetrySystemValues(serverConfiguration)
    Option(serverConfiguration.getSpringCloudEncryptKey)
      .foreach(System.setProperty("encrypt.key", _))
    this
  }

}
