package com.xebialabs.deployit.env

import ai.digital.config.AbstractEnvironmentPreparedProcessor
import com.xebialabs.deployit.{ServerConfiguration, ServerLaunchOptions}
import org.springframework.boot.{ConfigurableBootstrapContext, SpringApplication}
import org.springframework.core.Ordered
import org.springframework.core.annotation.Order
import org.springframework.core.env.ConfigurableEnvironment

@Order(Ordered.LOWEST_PRECEDENCE)
class ServerEnvironmentPreparedProcessor(application: SpringApplication, val args: Array[String]) extends AbstractEnvironmentPreparedProcessor {

  override def environmentPrepared(bootstrapContext: ConfigurableBootstrapContext, environment: ConfigurableEnvironment): Unit =
     if (areDeployServerProfilesActive(environment)) {
      super.addPropertySource(springCloudEnvironment(bootstrapContext, environment), bootstrapContext, environment)
     }

  private def areDeployServerProfilesActive(environment: ConfigurableEnvironment): Boolean = {
    ServerActiveProfileRegistry.allActiveProfiles(ServerLaunchOptions.getInstance(), ServerConfiguration.getInstance())
      .sameElements(environment.getActiveProfiles)
  }

  protected override val propertyResourceName: String = "default-server-env"
}
