/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config.session;

import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate;
import com.xebialabs.deployit.repository.sql.DeployJdbcIndexedSessionRepository;
import com.xebialabs.deployit.security.SpringSessionConverterFactory;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@ConditionalOnClass(value={JdbcTemplate.class, DeployJdbcIndexedSessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={JdbcSessionProperties.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
public class SpringJdbcSessionConfig
extends SpringHttpSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    static final String DEFAULT_CLEANUP_CRON = "0 * * * * *";
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String tableName = "SPRING_SESSION";
    private String cleanupCron = "0 * * * * *";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private TransactionOperations transactionOperations;
    private IndexResolver<Session> indexResolver;
    private LobHandler lobHandler;
    private ConversionService springSessionConversionService;
    private ConversionService conversionService;
    private List<SessionRepositoryCustomizer<DeployJdbcIndexedSessionRepository>> sessionRepositoryCustomizers;
    private ClassLoader classLoader;
    private StringValueResolver embeddedValueResolver;
    private SpringSessionConverterFactory springSessionConverterFactory;

    @Bean
    @Primary
    public DeployJdbcIndexedSessionRepository sessionRepository() {
        JdbcTemplate jdbcTemplate = SpringJdbcSessionConfig.createJdbcTemplate(this.dataSource);
        if (this.transactionOperations == null) {
            this.transactionOperations = SpringJdbcSessionConfig.createTransactionTemplate(this.transactionManager);
        }
        DeployJdbcIndexedSessionRepository sessionRepository = new DeployJdbcIndexedSessionRepository((JdbcOperations)jdbcTemplate, this.transactionOperations);
        if (StringUtils.hasText((String)this.tableName)) {
            sessionRepository.setTableName(this.tableName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (this.lobHandler != null) {
            sessionRepository.setLobHandler(this.lobHandler);
        } else if (SpringJdbcSessionConfig.requiresTemporaryLob(this.dataSource)) {
            DefaultLobHandler defaultLobHandler = new DefaultLobHandler();
            defaultLobHandler.setCreateTemporaryLob(true);
            sessionRepository.setLobHandler((LobHandler)defaultLobHandler);
        }
        if (this.springSessionConversionService != null) {
            sessionRepository.setConversionService(this.springSessionConversionService);
        } else if (this.conversionService != null) {
            sessionRepository.setConversionService(this.conversionService);
        } else {
            sessionRepository.setConversionService((ConversionService)this.createConversionServiceWithBeanClassLoader(this.classLoader));
        }
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    private static boolean requiresTemporaryLob(DataSource dataSource) {
        try {
            String productName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductName");
            return "Oracle".equalsIgnoreCase(JdbcUtils.commonDatabaseName((String)productName));
        }
        catch (MetaDataAccessException ex) {
            return false;
        }
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCleanupCron(String cleanupCron) {
        this.cleanupCron = cleanupCron;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, ObjectProvider<DataSource> dataSource) {
        DataSource dataSourceToUse = (DataSource)springSessionDataSource.getIfAvailable();
        if (dataSourceToUse == null) {
            dataSourceToUse = (DataSource)dataSource.getObject();
        }
        this.dataSource = dataSourceToUse;
    }

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionTransactionOperations")
    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionLobHandler")
    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionConversionService")
    public void setSpringSessionConversionService(ConversionService conversionService) {
        this.springSessionConversionService = conversionService;
    }

    @Autowired(required=false)
    @Qualifier(value="conversionService")
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<DeployJdbcIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Autowired(required=false)
    public void setSpringSessionConverterFactory(SpringSessionConverterFactory springSessionConverterFactory) {
        this.springSessionConverterFactory = springSessionConverterFactory;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableJdbcHttpSession.class.getName());
        if (attributeMap != null) {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
            this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
            String tableNameValue = attributes.getString("tableName");
            if (StringUtils.hasText((String)tableNameValue)) {
                this.tableName = this.embeddedValueResolver.resolveStringValue(tableNameValue);
            }
            this.flushMode = (FlushMode)attributes.getEnum("flushMode");
            this.saveMode = (SaveMode)attributes.getEnum("saveMode");
        }
    }

    private static JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        DeployJdbcTemplate jdbcTemplate = new DeployJdbcTemplate(dataSource, true);
        jdbcTemplate.afterPropertiesSet();
        return jdbcTemplate;
    }

    private static TransactionTemplate createTransactionTemplate(PlatformTransactionManager transactionManager) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader(ClassLoader classLoader) {
        GenericConversionService conversionService = new GenericConversionService();
        if (this.springSessionConverterFactory != null) {
            conversionService.addConverter(this.springSessionConverterFactory.buildSerializer(classLoader));
            conversionService.addConverter(this.springSessionConverterFactory.buildDeserializer(classLoader));
        } else {
            conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
            conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(classLoader));
        }
        return conversionService;
    }

    @EnableScheduling
    @Configuration(proxyBeanMethods=false)
    class SessionCleanupConfiguration
    implements SchedulingConfigurer {
        private final DeployJdbcIndexedSessionRepository sessionRepository;

        SessionCleanupConfiguration(DeployJdbcIndexedSessionRepository sessionRepository) {
            this.sessionRepository = sessionRepository;
        }

        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            taskRegistrar.addCronTask(() -> ((DeployJdbcIndexedSessionRepository)this.sessionRepository).cleanUpExpiredSessions(), SpringJdbcSessionConfig.this.cleanupCron);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Primary
    static class SpringBootJdbcHttpJdbcSessionConfiguration
    extends SpringJdbcSessionConfig {
        SpringBootJdbcHttpJdbcSessionConfiguration() {
        }

        @Autowired
        void customize(SessionProperties sessionProperties, JdbcSessionProperties jdbcSessionProperties, ServerProperties serverProperties) {
            Duration timeout = sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout());
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds((int)timeout.getSeconds());
            }
            this.setTableName(jdbcSessionProperties.getTableName());
            this.setCleanupCron(jdbcSessionProperties.getCleanupCron());
            this.setFlushMode(jdbcSessionProperties.getFlushMode());
            this.setSaveMode(jdbcSessionProperties.getSaveMode());
        }
    }
}

