package com.xebialabs.deployit.core.config.platform

import java.io.File

import ai.digital.configuration.central.deploy.TaskerSystemProperties
import ai.digital.configuration.central.deploy.converter.HoconDurationConverter
import ai.digital.deploy.core.common.AkkaTimeoutConverter
import akka.util.Timeout
import com.xebialabs.xlplatform.settings.shared.TaskerSettings
import org.springframework.beans.factory.annotation.{Autowired, Value}
import org.springframework.context.annotation.Configuration

import scala.concurrent.duration.FiniteDuration

@Configuration
class TaskerConfiguration extends TaskerSettings {

  @Autowired
  var taskerSystemProperties: TaskerSystemProperties = _

  override def recoveryDir: File = new File(taskerSystemProperties.recoveryDir)

  override def maxActiveTasks: Int = taskerSystemProperties.maxActiveTasks

  override def shutdownTimeout: FiniteDuration = HoconDurationConverter.convert(taskerSystemProperties.shutdownTimeout)

  override def tickDuration: FiniteDuration = HoconDurationConverter.convert(taskerSystemProperties.scheduler.system.akka.scheduler.tickDuration)

  override def stepRetryDelay: FiniteDuration = HoconDurationConverter.convert(taskerSystemProperties.step.retryDelay)

  override def enableCopyArtifactRetry: Boolean = taskerSystemProperties.step.onCopyArtifact.enableRetry

  @Value("${xl.tasker.askTimeout:10 seconds}") // TODO: missed configuration thru central-config, should be possible
  var askTimeoutProp: String = _

  override def askTimeout: Timeout = AkkaTimeoutConverter.convert(askTimeoutProp)

  override def stepRunTimeout: FiniteDuration = HoconDurationConverter.convert(taskerSystemProperties.step.runTimeout)

  override def stepRetryCount: Int = taskerSystemProperties.step.maxRetryNumber // 6 hours of default timeout / retry every 5 second

  @Value("${akka.io.dns.resolver:async-dns}")
  var dnsResolverProp: String = _

  override def asyncDnsEnabled: Boolean = Option(dnsResolverProp).exists(r => r.equals("async-dns"))


}
