package com.xebialabs.deployit.core.config

import ai.digital.configuration.central.deploy._
import ai.digital.deploy.core.common.security.permission.{DeployitPermissions, StitchPermissions}
import com.xebialabs.deployit.security.permission.PlatformPermissions
import com.xebialabs.xldeploy.packager.io.StreamerFactory
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner
import com.xebialabs.xlplatform.security.validator.regex.RegexValidator
import com.xebialabs.xlplatform.security.validator.regex.RegexValidator.RegexValidation
import org.springframework.beans.factory.annotation.{Autowired, Value}
import org.springframework.cloud.context.config.annotation.RefreshScope
import org.springframework.context.annotation.{Bean, Configuration, Import}

import scala.jdk.CollectionConverters._

@Configuration
@Import(Array(
  classOf[ArchiveExtensionMappingsProperties],
  classOf[ArtifactResolverProperties],
  classOf[ClientProperties],
  classOf[ClusterProperties],
  classOf[MetricsProperties],
  classOf[PropertyResolversConfiguration],
  classOf[OidcProperties],
  classOf[SecretComplexityProperties],
  classOf[ServerSideProperties],
  classOf[TaskerSystemProperties],
  classOf[WebSocketsProperties],
))
class XldSpringConfig {

  PlatformPermissions.init()
  DeployitPermissions.init()
  StitchPermissions.init()

  @Value("${deploy.downloads.export-root:export}")
  var exportRoot: String = _

  @Bean
  def exportRootPath: String = exportRoot

  @Autowired
  var compexity: SecretComplexityProperties = _

  @Autowired
  var archiveMappings: ArchiveExtensionMappingsProperties = _

  @Bean
  def archiveExtensionMappings: Map[String, String] = archiveMappings.archiveExtensions.asScala.toMap

  @Bean
  def streamerFactory: StreamerFactory = new StreamerFactory(archiveExtensionMappings,
    archiveMappings.zipEncoding, archiveMappings.jarEncoding)

  @Bean
  @Autowired
  def sourceArtifactScanner(streamerFactory: StreamerFactory): SourceArtifactScanner = new SourceArtifactScanner(streamerFactory)

  @Bean
  @RefreshScope
  def passwordValidator: RegexValidator =
    new RegexValidator(validators = compexity.regexValidations.asScala.toList
      .grouped(2)
      .map {
        case List(regex, message) => RegexValidation(regex.r, message)
        case item => throw new RuntimeException(s"Unexpected regex input for password validator $item")
      }
      .toList)
}
