package com.xebialabs.deployit.core.config

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.spring.DecodingPropertyPlaceholderConfigurer
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer

@ConditionalOnExpression("T(com.xebialabs.deployit.ServerConfiguration).getInstance().getConfigResource() != null")
@Configuration
class PropertyResolversConfiguration {

  @Bean
  def propertyConfigurer: DecodingPropertyPlaceholderConfigurer = {
    val configurer = new DecodingPropertyPlaceholderConfigurer()
    val resource = ServerConfiguration.getInstance().getConfigResource
    configurer.setLocation(resource)
    configurer.setIgnoreUnresolvablePlaceholders(true)
    configurer.setValueSeparator("=")
    configurer
  }

  @Bean
  def sourcesConfigurer: PropertySourcesPlaceholderConfigurer = {
    val configurer = new PropertySourcesPlaceholderConfigurer()
    configurer.setNullValue("@null")
    configurer
  }
}
