package com.xebialabs.deployit.env

import com.xebialabs.deployit.spring.profile.DynamicActiveProfile
import nl.javadude.scannit.Scannit

import java.util.concurrent.atomic.AtomicReference
import scala.jdk.CollectionConverters._

trait DynamicActiveProfileRegistry {
  protected val Refs = new AtomicReference[Array[_ <: DynamicActiveProfile]]()

  protected def init(): Unit = {
    val registeredProfiles = Scannit.getInstance().getSubTypesOf(classOf[DynamicActiveProfile]).asScala
      .map(_.getConstructor().newInstance())
    Refs.set(registeredProfiles.toArray)
  }

  def allDefaultProfiles(): Array[String]

  def getDefaultProfiles: String = allDefaultProfiles().mkString(",")
}
