package com.xebialabs.deployit.env

import com.xebialabs.deployit.{ServerConfiguration, ServerLaunchOptions}
import com.xebialabs.deployit.spring.profile.DynamicActiveProfile
import nl.javadude.scannit.Scannit

import java.util.concurrent.atomic.AtomicReference
import scala.jdk.CollectionConverters._

object ServerActiveProfileRegistry {
  protected val Refs = new AtomicReference[Array[_ <: DynamicActiveProfile]]()

  private def init(): Unit = {
    val registeredProfiles = Scannit.getInstance().getSubTypesOf(classOf[DynamicActiveProfile]).asScala
      .map(_.getConstructor().newInstance())
    Refs.set(registeredProfiles.toArray)
  }

  private def disableDynamicProfile(launchOptions: ServerLaunchOptions,
                                    serverConfig: ServerConfiguration,
                                    profileName: String): Boolean = {
    Refs.get().find(_.profileNames.contains(profileName))
      .forall(p => p.configPropertyCallback(serverConfig) || p.launchOptionsCallback(launchOptions))
  }

  def allActiveProfiles(launchOptions: ServerLaunchOptions,
                        serverConfig: ServerConfiguration): Array[String] = {
    allDynamicActiveProfiles(launchOptions, serverConfig) ++ allDefaultProfiles()
  }

  def allDynamicActiveProfiles(launchOptions: ServerLaunchOptions,
                               serverConfig: ServerConfiguration): Array[String] = {
    if(Option(Refs.get()).forall(_.isEmpty)) {
      init()
    }
    Refs.get().filter(p => !(p.configPropertyCallback(serverConfig) || p.launchOptionsCallback(launchOptions)))
      .flatMap(_.profileNames)
  }

  def allDefaultProfiles(): Array[String] = ServerActiveProfiles.values.map(_.toString).toArray

  def getActiveProfiles(launchOptions: ServerLaunchOptions,
                        serverConfig: ServerConfiguration): String =
    allActiveProfiles(launchOptions, serverConfig).mkString(",")

  def getDefaultProfiles: String = allDefaultProfiles().mkString(",")
}
