package com.xebialabs.deployit.core.config

package object hash {

  val defaultWhitelistedPaths: Seq[String] = Seq("xl")

  private def loggerExclusions(namespaces: String*): Set[String] =
    namespaces
      .flatMap(namespace => Set(s"$namespace.loggers", s"$namespace.loglevel"))
      .toSet

  val defaultBlacklistedConfigurationKeys: Set[String] = Set(
    "xl.central.configuration.",
    "xl.conf-file.",
    "xl.spring.cloud.",
    "xl.worker."
  ) ++ loggerExclusions(
    namespaces =
      "akka",
      "xl.system.akka"
  )
}
