package com.xebialabs.deployit.core.config.hash

import java.io.File

import com.typesafe.config.Config
import com.xebialabs.deployit.repository.ConfigurationVersionRepository
import grizzled.slf4j.Logging

case class DatabaseConfigurationHashProvider(configurationVersionRepository: ConfigurationVersionRepository)
                                            (files: Seq[File], configs: Seq[Config],
                                             whitelistedConfigurationPaths: Seq[String], blacklistedConfigurationKeys: Set[String])
  extends DefaultConfigurationHashProvider(files, configs, whitelistedConfigurationPaths, blacklistedConfigurationKeys) with Logging {

  def init(): Unit = {
    info(s"Started with configuration hash: [$configurationHash]")
    configurationVersionRepository.save(configurationHash)
  }

}
